/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.FederationMetadataRequest;
import org.xdi.oxauth.client.FederationMetadataResponse;
import org.xdi.oxauth.model.federation.FederationMetadata;
import org.xdi.oxauth.model.federation.FederationOP;
import org.xdi.oxauth.model.federation.FederationRP;
import org.xdi.oxauth.model.jwt.PureJwt;
import org.xdi.oxauth.model.util.Util;

public class FederationMetadataClient
extends BaseClient<FederationMetadataRequest, FederationMetadataResponse> {
    private static final Logger LOG = Logger.getLogger(FederationMetadataClient.class);

    public FederationMetadataClient(String url) {
        super(url);
    }

    @Override
    public FederationMetadataRequest getRequest() {
        if (this.request instanceof FederationMetadataRequest) {
            return (FederationMetadataRequest)this.request;
        }
        return null;
    }

    @Override
    public void setRequest(FederationMetadataRequest request) {
        this.request = request;
    }

    @Override
    public FederationMetadataResponse getResponse() {
        if (this.response instanceof FederationMetadataResponse) {
            return (FederationMetadataResponse)this.response;
        }
        return null;
    }

    @Override
    public void setResponse(FederationMetadataResponse response) {
        this.response = response;
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public FederationMetadataResponse execGetMetadataIds() {
        return this.exec(new FederationMetadataRequest());
    }

    public FederationMetadataResponse execGetMetadataById(String p_federationMetadataId) {
        return this.exec(new FederationMetadataRequest(p_federationMetadataId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FederationMetadataResponse exec(FederationMetadataRequest p_request) {
        this.setResponse(new FederationMetadataResponse());
        String httpMethod = this.getHttpMethod();
        this.initClientRequest();
        this.clientRequest.header("Content-Type", (Object)"application/json");
        this.clientRequest.setHttpMethod(httpMethod);
        try {
            if ("GET".equals(httpMethod)) {
                FederationMetadataClient.prepareRequest(p_request, this.clientRequest);
                this.clientResponse = this.clientRequest.get(String.class);
                this.setRequest(p_request);
                String entity = (String)this.clientResponse.getEntity(String.class);
                this.getResponse().setStatus(this.clientResponse.getStatus());
                this.getResponse().setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
                this.getResponse().setLocation(this.clientResponse.getLocation() != null ? this.clientResponse.getLocation().getHref() : "");
                FederationMetadataClient.fillResponse(this.getResponse(), entity, p_request.isSigned());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return this.getResponse();
    }

    private static void prepareRequest(FederationMetadataRequest p_request, ClientRequest p_clientRequest) {
        if (StringUtils.isNotBlank((String)p_request.getFederationId())) {
            p_clientRequest.queryParameter("federation_id", (Object)p_request.getFederationId());
        }
        if (!p_request.isSigned()) {
            p_clientRequest.queryParameter("signed", (Object)p_request.isSigned());
        }
    }

    public static void fillResponse(FederationMetadataResponse p_response, String entity, boolean p_signed) {
        p_response.setEntity(entity);
        if (StringUtils.isNotBlank((String)entity)) {
            p_response.injectErrorIfExistSilently(entity);
            if (p_signed) {
                PureJwt jwt = PureJwt.parse((String)entity);
                if (jwt != null) {
                    String decodedPayload = jwt.getDecodedPayload();
                    try {
                        p_response.setMetadata(FederationMetadataClient.convertMetadata(new JSONObject(decodedPayload)));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        p_response.setExistingMetadataIdList(FederationMetadataClient.convertMetadataIdList(entity));
                    }
                    catch (JSONException e) {}
                }
            } else {
                try {
                    p_response.setExistingMetadataIdList(FederationMetadataClient.convertMetadataIdList(entity));
                }
                catch (JSONException e) {
                    // empty catch block
                }
                try {
                    p_response.setMetadata(FederationMetadataClient.convertMetadata(new JSONObject(entity)));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static FederationMetadata convertMetadata(JSONObject p_jsonObj) throws JSONException {
        int i;
        FederationMetadata metadata = new FederationMetadata();
        if (p_jsonObj.has("federation_id")) {
            metadata.setId(p_jsonObj.getString("federation_id"));
        }
        if (p_jsonObj.has("display_name")) {
            metadata.setDisplayName(p_jsonObj.getString("display_name"));
        }
        if (p_jsonObj.has("interval_check")) {
            metadata.setIntervalCheck(p_jsonObj.getString("interval_check"));
        }
        if (p_jsonObj.get("OPs") instanceof JSONArray) {
            ArrayList<FederationOP> opList = new ArrayList<FederationOP>();
            metadata.setOpList(opList);
            JSONArray oPs = (JSONArray)p_jsonObj.get("OPs");
            for (i = 0; i < oPs.length(); ++i) {
                opList.add(FederationMetadataClient.convertOP(oPs.getJSONObject(i)));
            }
        }
        if (p_jsonObj.get("RPs") instanceof JSONArray) {
            ArrayList<FederationRP> rpList = new ArrayList<FederationRP>();
            metadata.setRpList(rpList);
            JSONArray rPs = (JSONArray)p_jsonObj.get("RPs");
            for (i = 0; i < rPs.length(); ++i) {
                rpList.add(FederationMetadataClient.convertRP(rPs.getJSONObject(i)));
            }
        }
        return metadata;
    }

    public static List<String> convertMetadataIdList(String p_jsonAsString) throws JSONException {
        JSONArray jsonArray = new JSONArray(p_jsonAsString);
        return Util.asList((JSONArray)jsonArray);
    }

    public static FederationOP convertOP(JSONObject p_json) throws JSONException {
        FederationOP op = new FederationOP();
        if (p_json != null) {
            if (p_json.has("display_name")) {
                op.setDisplayName(p_json.getString("display_name"));
            }
            if (p_json.has("op_id")) {
                op.setOpId(p_json.getString("op_id"));
            }
            if (p_json.has("domain")) {
                op.setDomain(p_json.getString("domain"));
            }
        }
        return op;
    }

    public static FederationRP convertRP(JSONObject p_json) throws JSONException {
        FederationRP rp = new FederationRP();
        if (p_json != null) {
            if (p_json.has("display_name")) {
                rp.setDisplayName(p_json.getString("display_name"));
            }
            if (p_json.has("redirect_uri")) {
                ArrayList<String> redirectUriList = new ArrayList<String>();
                rp.setRedirectUri(redirectUriList);
                Object redirectUriObject = p_json.get("redirect_uri");
                if (redirectUriObject instanceof String) {
                    redirectUriList.add((String)redirectUriObject);
                } else if (redirectUriObject instanceof JSONArray) {
                    JSONArray array = (JSONArray)redirectUriObject;
                    for (int i = 0; i < array.length(); ++i) {
                        redirectUriList.add(array.getString(i));
                    }
                } else if (redirectUriObject != null) {
                    redirectUriList.add(redirectUriObject.toString());
                }
            }
        }
        return rp;
    }
}

