/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.FederationDataRequest;
import org.xdi.oxauth.client.FederationDataResponse;
import org.xdi.oxauth.model.federation.FederationRequest;

public class FederationDataClient
extends BaseClient<FederationDataRequest, FederationDataResponse> {
    private static final Logger LOG = Logger.getLogger(FederationDataClient.class);

    public FederationDataClient(String url) {
        super(url);
    }

    @Override
    public FederationDataRequest getRequest() {
        if (this.request instanceof FederationDataRequest) {
            return (FederationDataRequest)this.request;
        }
        return null;
    }

    @Override
    public void setRequest(FederationDataRequest request) {
        this.request = request;
    }

    @Override
    public FederationDataResponse getResponse() {
        if (this.response instanceof FederationDataResponse) {
            return (FederationDataResponse)this.response;
        }
        return null;
    }

    @Override
    public void setResponse(FederationDataResponse response) {
        this.response = response;
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public FederationDataResponse joinRP(String p_federationId, String p_displayName, String p_redirectUri) {
        return this.joinRP(p_federationId, p_displayName, p_redirectUri, null, null);
    }

    public FederationDataResponse joinRP(String p_federationId, String p_displayName, String p_redirectUri, String p_x509pem, String p_x509url) {
        this.setRequest(new FederationDataRequest());
        this.getRequest().setType(FederationRequest.Type.RP);
        this.getRequest().setFederationId(p_federationId);
        this.getRequest().setDisplayName(p_displayName);
        this.getRequest().setRedirectUri(p_redirectUri);
        this.getRequest().setX509pem(p_x509pem);
        this.getRequest().setX509url(p_x509url);
        return this.exec(this.getRequest());
    }

    public FederationDataResponse joinOP(String p_federationId, String p_displayName, String p_opId, String p_domain) {
        return this.joinOP(p_federationId, p_displayName, p_opId, p_domain, null, null);
    }

    public FederationDataResponse joinOP(String p_federationId, String p_displayName, String p_opId, String p_domain, String p_x509pem, String p_x509url) {
        this.setRequest(new FederationDataRequest());
        this.getRequest().setType(FederationRequest.Type.OP);
        this.getRequest().setFederationId(p_federationId);
        this.getRequest().setDisplayName(p_displayName);
        this.getRequest().setOpId(p_opId);
        this.getRequest().setDomain(p_domain);
        this.getRequest().setX509pem(p_x509pem);
        this.getRequest().setX509url(p_x509url);
        return this.exec(this.getRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FederationDataResponse exec(FederationDataRequest p_request) {
        block8: {
            this.setResponse(new FederationDataResponse());
            String httpMethod = this.getHttpMethod();
            this.initClientRequest();
            this.clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
            this.clientRequest.setHttpMethod(httpMethod);
            try {
                if ("POST".equals(httpMethod)) {
                    FederationDataClient.putAllFormParameters(this.clientRequest, p_request);
                    this.clientResponse = this.clientRequest.post(String.class);
                    this.setRequest(p_request);
                    String entity = (String)this.clientResponse.getEntity(String.class);
                    this.getResponse().setStatus(this.clientResponse.getStatus());
                    this.getResponse().setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
                    this.getResponse().setLocation(this.clientResponse.getLocation() != null ? this.clientResponse.getLocation().getHref() : "");
                    this.getResponse().setEntity(entity);
                    if (StringUtils.isNotBlank((String)entity)) {
                        this.getResponse().injectErrorIfExistSilently(entity);
                    }
                    break block8;
                }
                LOG.error((Object)("HTTP method is not supported. Method:" + httpMethod));
                throw new UnsupportedOperationException("HTTP method is not supported. Method:" + httpMethod);
            }
            catch (UnsupportedOperationException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.closeConnection();
            }
        }
        return this.getResponse();
    }
}

