/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.EndSessionRequest;
import org.xdi.oxauth.client.EndSessionResponse;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.model.common.Parameters;
import org.xdi.oxauth.model.session.EndSessionErrorResponseType;

public class EndSessionClient
extends BaseClient<EndSessionRequest, EndSessionResponse> {
    private static final String mediaType = "text/plain";

    public EndSessionClient(String url) {
        super(url);
    }

    @Override
    public EndSessionRequest getRequest() {
        if (this.request instanceof EndSessionRequest) {
            return (EndSessionRequest)this.request;
        }
        return null;
    }

    @Override
    public void setRequest(EndSessionRequest request) {
        this.request = request;
    }

    @Override
    public EndSessionResponse getResponse() {
        if (this.response instanceof EndSessionResponse) {
            return (EndSessionResponse)this.response;
        }
        return null;
    }

    @Override
    public void setResponse(EndSessionResponse response) {
        this.response = response;
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public EndSessionResponse execEndSession(String idTokenHint, String postLogoutRedirectUri) {
        this.setRequest(new EndSessionRequest(idTokenHint, postLogoutRedirectUri));
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndSessionResponse exec() {
        block16: {
            this.initClientRequest();
            this.clientRequest.accept(mediaType);
            this.clientRequest.setHttpMethod(this.getHttpMethod());
            if (StringUtils.isNotBlank((String)this.getRequest().getIdTokenHint())) {
                this.clientRequest.queryParameter("id_token_hint", (Object)this.getRequest().getIdTokenHint());
            }
            if (StringUtils.isNotBlank((String)this.getRequest().getPostLogoutRedirectUri())) {
                this.clientRequest.queryParameter("post_logout_redirect_uri", (Object)this.getRequest().getPostLogoutRedirectUri());
            }
            if (StringUtils.isNotBlank((String)this.getRequest().getState())) {
                this.clientRequest.queryParameter("state", (Object)this.getRequest().getState());
            }
            if (StringUtils.isNotBlank((String)this.getRequest().getSessionId())) {
                this.clientRequest.queryParameter(Parameters.SESSION_ID.getParamName(), (Object)this.getRequest().getSessionId());
            }
            try {
                this.clientResponse = this.clientRequest.get(String.class);
                int status = this.clientResponse.getStatus();
                this.setResponse(new EndSessionResponse(status));
                String entity = (String)this.clientResponse.getEntity(String.class);
                this.getResponse().setEntity(entity);
                this.getResponse().setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
                if (this.clientResponse.getLocation() != null) {
                    String queryString;
                    Map<String, String> params;
                    String location = this.clientResponse.getLocation().getHref();
                    this.getResponse().setLocation(location);
                    int queryStringIndex = location.indexOf("?");
                    if (queryStringIndex != -1 && (params = QueryStringDecoder.decode(queryString = location.substring(queryStringIndex + 1))).containsKey("state")) {
                        this.getResponse().setState(params.get("state"));
                    }
                }
                if (entity == null || entity.equals("")) break block16;
                try {
                    JSONObject jsonObj = new JSONObject(entity);
                    if (jsonObj.has("error")) {
                        this.getResponse().setErrorType(EndSessionErrorResponseType.fromString((String)jsonObj.getString("error")));
                    }
                    if (jsonObj.has("error_description")) {
                        this.getResponse().setErrorDescription(jsonObj.getString("error_description"));
                    }
                    if (jsonObj.has("error_uri")) {
                        this.getResponse().setErrorUri(jsonObj.getString("error_uri"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.closeConnection();
            }
        }
        return this.getResponse();
    }
}

