/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class UserAuthenticationFilterHttpTest
extends BaseTest {
    @Parameters(value={"redirectUris", "userInum", "userEmail"})
    @Test
    public void requestAccessTokenCustomAuth1(String redirectUris, String userInum, String userEmail) throws Exception {
        this.showTitle("requestAccessTokenCustomAuth1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setScope("openid");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.addCustomParameter("mail", userEmail);
        tokenRequest.addCustomParameter("inum", userInum);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse response1 = tokenClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The id token is null");
    }

    @Parameters(value={"redirectUris", "userId", "userSecret"})
    @Test
    public void requestAccessTokenCustomAuth2(String redirectUris, String userId, String userSecret) throws Exception {
        this.showTitle("requestAccessTokenCustomAuth2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setScope("openid");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.addCustomParameter("uid", userId);
        tokenRequest.addCustomParameter("pwd", userSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse response1 = tokenClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The id token is null");
    }

    @Parameters(value={"redirectUris", "userInum", "userEmail"})
    @Test
    public void requestAccessTokenCustomAuth3(String redirectUris, String userInum, String userEmail) throws Exception {
        this.showTitle("requestAccessTokenCustomAuth3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setScope("openid");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.addCustomParameter("mail", userEmail);
        tokenRequest.addCustomParameter("inum", userInum);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse response1 = tokenClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The id token is null");
    }

    @Parameters(value={"userId", "userSecret", "redirectUris"})
    @Test
    public void requestAccessTokenCustomAuth4(String userId, String userSecret, String redirectUris) throws Exception {
        this.showTitle("requestAccessTokenCustomAuth4");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        TokenRequest tokenRequest = new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        tokenRequest.setScope("openid");
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.addCustomParameter("uid", userId);
        tokenRequest.addCustomParameter("pwd", userSecret);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse response1 = tokenClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The id token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userInum", "userEmail"})
    @Test
    public void requestAccessTokenCustomAuth5(String redirectUris, String redirectUri, String userInum, String userEmail) throws Exception {
        this.showTitle("requestAccessTokenCustomAuth5");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        request.setState(state);
        request.getPrompts().add(Prompt.NONE);
        request.addCustomParameter("mail", userEmail);
        request.addCustomParameter("inum", userInum);
        request.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(request);
        AuthorizationResponse response1 = authorizeClient.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        String authorizationCode = response1.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        tokenClient1.setRequest(tokenRequest);
        TokenResponse response2 = tokenClient1.exec();
        UserAuthenticationFilterHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response2.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response2.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)response2.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response2.getRefreshToken(), (String)"The refresh token is null");
    }
}

