/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.util.StringUtils;

public class TokenEndpointAuthMethodRestrictionHttpTest
extends BaseTest {
    @Parameters(value={"redirectUris"})
    @Test
    public void omittedTokenEndpointAuthMethod(String redirectUris) throws Exception {
        this.showTitle("omittedTokenEndpointAuthMethod");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse registerResponse = registerClient.execRegister(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void tokenEndpointAuthMethodClientSecretBasic(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretBasic");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void tokenEndpointAuthMethodClientSecretBasicFail1(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretBasicFail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void tokenEndpointAuthMethodClientSecretBasicFail2(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretBasicFail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "RS256_modulus", "RS256_privateExponent"})
    @Test
    public void tokenEndpointAuthMethodClientSecretBasicFail3(String redirectUris, String redirectUri, String userId, String userSecret, String modulus, String privateExponent) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretBasicFail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_BASIC.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        RSAPrivateKey privateKey = new RSAPrivateKey(modulus, privateExponent);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setRsaPrivateKey(privateKey);
        tokenRequest.setKeyId("RS256SIG");
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void tokenEndpointAuthMethodClientSecretPost(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretPost");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_POST.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void tokenEndpointAuthMethodClientSecretPostFail1(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretPostFail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_POST.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void tokenEndpointAuthMethodClientSecretPostFail2(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretPostFail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_POST.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "RS256_modulus", "RS256_privateExponent"})
    @Test
    public void tokenEndpointAuthMethodClientSecretPostFail3(String redirectUris, String redirectUri, String userId, String userSecret, String modulus, String privateExponent) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretPostFail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_POST.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        RSAPrivateKey privateKey = new RSAPrivateKey(modulus, privateExponent);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setRsaPrivateKey(privateKey);
        tokenRequest.setKeyId("RS256SIG");
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwt(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwt");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtFail1(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtFail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtFail2(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtFail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "RS256_modulus", "RS256_privateExponent"})
    @Test
    public void tokenEndpointAuthMethodClientSecretJwtFail3(String redirectUris, String redirectUri, String userId, String userSecret, String modulus, String privateExponent) throws Exception {
        this.showTitle("tokenEndpointAuthMethodClientSecretJwtFail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.CLIENT_SECRET_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        RSAPrivateKey privateKey = new RSAPrivateKey(modulus, privateExponent);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setRsaPrivateKey(privateKey);
        tokenRequest.setKeyId("RS256SIG");
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS256_modulus", "RS256_privateExponent"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwt(String redirectUris, String redirectUri, String userId, String userSecret, String clientJwksUri, String modulus, String privateExponent) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwt");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        registerRequest.setJwksUri(clientJwksUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        RSAPrivateKey privateKey = new RSAPrivateKey(modulus, privateExponent);
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        tokenRequest.setAlgorithm(SignatureAlgorithm.RS256);
        tokenRequest.setRsaPrivateKey(privateKey);
        tokenRequest.setKeyId("RS256SIG");
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtFail1(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtFail1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(this.jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtFail2(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtFail2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(this.jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void tokenEndpointAuthMethodPrivateKeyJwtFail3(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("tokenEndpointAuthMethodPrivateKeyJwtFail3");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(this.jwksUri);
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertTrue((boolean)readClientResponse.getClaims().containsKey(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())), (String)AuthenticationMethod.PRIVATE_KEY_JWT.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNull((Object)authorizationResponse.getIdToken(), (String)"The id token is not null");
        String authorizationCode = authorizationResponse.getCode();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setAudience(this.tokenEndpoint);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        tokenClient.setRequest(tokenRequest);
        TokenResponse tokenResponse = tokenClient.exec();
        TokenEndpointAuthMethodRestrictionHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)401, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }
}

