/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.ArrayList;
import java.util.Arrays;
import org.codehaus.jettison.json.JSONArray;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.util.StringUtils;

public class RegistrationRestWebServiceHttpTest
extends BaseTest {
    private String clientId1;
    private String registrationAccessToken1;
    private String registrationClientUri1;

    @Parameters(value={"redirectUris"})
    @Test
    public void requestClientAssociate1(String redirectUris) throws Exception {
        this.showTitle("requestClientAssociate1");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse response = registerClient.execRegister(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
    }

    @Parameters(value={"redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestClientAssociate2(String redirectUris, String sectorIdentifierUri) throws Exception {
        this.showTitle("requestClientAssociate2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setScopes(Arrays.asList("openid", "address", "profile", "email", "phone", "clientinfo", "invalid_scope"));
        registerRequest.setLogoUri("http://www.gluu.org/wp-content/themes/gluursn/images/logo.png");
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setPolicyUri("http://www.gluu.org/policy");
        registerRequest.setJwksUri("http://www.gluu.org/jwks");
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.setSubjectType(SubjectType.PUBLIC);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS256);
        registerRequest.setRequestUris(Arrays.asList("http://www.gluu.org/request"));
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.SCOPES.toString()));
        JSONArray scopesJsonArray = new JSONArray((String)response.getClaims().get(RegisterRequestParam.SCOPES.toString()));
        ArrayList<String> scopes = new ArrayList<String>();
        for (int i = 0; i < scopesJsonArray.length(); ++i) {
            scopes.add(scopesJsonArray.get(i).toString());
        }
        Assert.assertTrue((boolean)scopes.contains("openid"));
        Assert.assertTrue((boolean)scopes.contains("address"));
        Assert.assertTrue((boolean)scopes.contains("email"));
        Assert.assertTrue((boolean)scopes.contains("profile"));
        Assert.assertTrue((boolean)scopes.contains("phone"));
        Assert.assertTrue((boolean)scopes.contains("clientinfo"));
        this.clientId1 = response.getClientId();
        this.registrationAccessToken1 = response.getRegistrationAccessToken();
        this.registrationClientUri1 = response.getRegistrationClientUri();
    }

    @Test(dependsOnMethods={"requestClientAssociate2"})
    public void requestClientUpdate() throws Exception {
        this.showTitle("requestClientUpdate");
        String logoUriNewValue = "http://www.gluu.org/test/yuriy/logo.png";
        String contact1NewValue = "yuriy@gluu.org";
        String contact2NewValue = "yzabrovaniy@gmail.com";
        RegisterRequest registerRequest = new RegisterRequest(this.registrationAccessToken1);
        registerRequest.setHttpMethod("PUT");
        registerRequest.setContacts(Arrays.asList("yuriy@gluu.org", "yzabrovaniy@gmail.com"));
        registerRequest.setLogoUri("http://www.gluu.org/test/yuriy/logo.png");
        RegisterClient registerClient = new RegisterClient(this.registrationClientUri1);
        registerClient.setRequest(registerRequest);
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        String responseContacts = (String)response.getClaims().get(RegisterRequestParam.CONTACTS.toString());
        String responseLogoUri = (String)response.getClaims().get(RegisterRequestParam.LOGO_URI.toString());
        Assert.assertTrue((responseContacts.contains("yuriy@gluu.org") && responseContacts.contains("yzabrovaniy@gmail.com") ? 1 : 0) != 0);
        Assert.assertNotNull((Object)responseLogoUri.equals("http://www.gluu.org/test/yuriy/logo.png"));
    }

    @Test(dependsOnMethods={"requestClientAssociate2"})
    public void requestClientRead() throws Exception {
        this.showTitle("requestClientRead");
        RegisterRequest registerRequest = new RegisterRequest(this.registrationAccessToken1);
        RegisterClient registerClient = new RegisterClient(this.registrationClientUri1);
        registerClient.setRequest(registerRequest);
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getRegistrationClientUri());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.POLICY_URI.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.CONTACTS.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.SUBJECT_TYPE.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.JWKS_URI.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.LOGO_URI.toString()));
        Assert.assertNotNull(response.getClaims().get(RegisterRequestParam.REQUEST_URIS.toString()));
        Assert.assertNotNull(response.getClaims().get("scopes"));
    }

    @Parameters(value={"redirectUris"})
    @Test
    public void requestClientRegistrationWithCustomAttributes(String redirectUris) throws Exception {
        this.showTitle("requestClientRegistrationWithCustomAttributes");
        RegisterRequest request = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        request.addCustomAttribute("myCustomAttr1", "customAttrValue1");
        request.addCustomAttribute("myCustomAttr2", "customAttrValue2");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(request);
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
    }

    @Test
    public void requestClientRegistrationFail1() throws Exception {
        this.showTitle("requestClientRegistrationFail1");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse response = registerClient.execRegister(null, null, null);
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
    }

    @Test
    public void requestClientRegistrationFail2() throws Exception {
        this.showTitle("requestClientRegistrationFail2");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse response = registerClient.execRegister(ApplicationType.WEB, "oxAuth test app", null);
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
    }

    @Test
    public void requestClientRegistrationFail3() throws Exception {
        this.showTitle("requestClientRegistrationFail3");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse response = registerClient.execRegister(ApplicationType.WEB, "oxAuth test app", Arrays.asList("https://client.example.com/cb#fail_fragment"));
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris"})
    @Test
    public void requestClientAssociateWithFederationAttributes(String redirectUris) throws Exception {
        this.showTitle("requestClientAssociateWithFederationAttributes");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterRequest request = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        request.setFederationId("1234");
        request.setFederationUrl("http://federationMetadataUrl.org");
        registerClient.setRequest(request);
        RegisterResponse response = registerClient.exec();
        RegistrationRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
    }
}

