/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.JwkClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.util.StringUtils;

public class AuthorizationCodeFlowHttpTest
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri"})
    @Test
    public void authorizationCodeFlow(String userId, String userSecret, String redirectUris, String redirectUri) throws Exception {
        this.showTitle("authorizationCodeFlow");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        String scope = authorizationResponse.getScope();
        String authorizationCode = authorizationResponse.getCode();
        String idToken = authorizationResponse.getIdToken();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        tokenClient1.setRequest(tokenRequest);
        TokenResponse tokenResponse1 = tokenClient1.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)tokenResponse1.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse1.getStatus()));
        Assert.assertNotNull((Object)tokenResponse1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse1.getRefreshToken(), (String)"The refresh token is null");
        String refreshToken = tokenResponse1.getRefreshToken();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("oxValidationURI"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("oxOpenIDConnectVersion"));
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
        TokenClient tokenClient2 = new TokenClient(this.tokenEndpoint);
        TokenResponse tokenResponse2 = tokenClient2.execRefreshToken(scope, refreshToken, clientId, clientSecret);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient2);
        Assert.assertEquals((int)tokenResponse2.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse2.getStatus()));
        Assert.assertNotNull((Object)tokenResponse2.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse2.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse2.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse2.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)tokenResponse2.getScope(), (String)"The scope is null");
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri"})
    @Test
    public void authorizationCodeFlowWithOptionalNonce(String userId, String userSecret, String redirectUris, String redirectUri) throws Exception {
        this.showTitle("authorizationCodeFlowWithOptionalNonce");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        String scope = authorizationResponse.getScope();
        String authorizationCode = authorizationResponse.getCode();
        String idToken = authorizationResponse.getIdToken();
        TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest.setCode(authorizationCode);
        tokenRequest.setRedirectUri(redirectUri);
        tokenRequest.setAuthUsername(clientId);
        tokenRequest.setAuthPassword(clientSecret);
        tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        tokenClient1.setRequest(tokenRequest);
        TokenResponse tokenResponse1 = tokenClient1.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)tokenResponse1.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse1.getStatus()));
        Assert.assertNotNull((Object)tokenResponse1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse1.getRefreshToken(), (String)"The refresh token is null");
        String refreshToken = tokenResponse1.getRefreshToken();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("nonce"));
        Assert.assertEquals((String)jwt.getClaims().getClaimAsString("nonce"), (String)nonce);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("oxValidationURI"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("oxOpenIDConnectVersion"));
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
        TokenClient tokenClient2 = new TokenClient(this.tokenEndpoint);
        TokenResponse tokenResponse2 = tokenClient2.execRefreshToken(scope, refreshToken, clientId, clientSecret);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient2);
        Assert.assertEquals((int)tokenResponse2.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse2.getStatus()));
        Assert.assertNotNull((Object)tokenResponse2.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse2.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse2.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse2.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)tokenResponse2.getScope(), (String)"The scope is null");
    }

    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri"})
    @Test
    public void revokeTokens(String userId, String userSecret, String redirectUris, String redirectUri) throws Exception {
        this.showTitle("revokeTokens");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token is null");
        String scope = authorizationResponse.getScope();
        String authorizationCode = authorizationResponse.getCode();
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("typ"));
        Assert.assertNotNull((Object)jwt.getHeader().getClaimAsString("alg"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iss"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("aud"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("exp"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("iat"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("sub"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("c_hash"));
        Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("auth_time"));
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        TokenResponse response2 = tokenClient1.execAuthorizationCode(authorizationCode, redirectUri, clientId, clientSecret);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response2.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response2.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response2.getRefreshToken(), (String)"The refresh token is null");
        String accessToken = response2.getAccessToken();
        String refreshToken = response2.getRefreshToken();
        TokenClient tokenClient2 = new TokenClient(this.tokenEndpoint);
        TokenResponse response4 = tokenClient2.execAuthorizationCode(authorizationCode, redirectUri, clientId, clientSecret);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient2);
        Assert.assertEquals((int)response4.getStatus(), (int)400, (String)("Unexpected response code: " + response4.getStatus()));
        Assert.assertNotNull((Object)response4.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response4.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response4.getErrorDescription(), (String)"The error description is null");
        TokenClient tokenClient3 = new TokenClient(this.tokenEndpoint);
        TokenResponse response5 = tokenClient3.execRefreshToken(scope, refreshToken, clientId, clientSecret);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)tokenClient3);
        Assert.assertEquals((int)response5.getStatus(), (int)401, (String)("Unexpected response code: " + response5.getStatus()));
        Assert.assertNotNull((Object)response5.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response5.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response5.getErrorDescription(), (String)"The error description is null");
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response7 = userInfoClient.execUserInfo(accessToken);
        AuthorizationCodeFlowHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response7.getStatus(), (int)400, (String)("Unexpected response code: " + response7.getStatus()));
        Assert.assertNotNull((Object)response7.getErrorType(), (String)"Unexpected result: errorType not found");
        Assert.assertNotNull((Object)response7.getErrorDescription(), (String)"Unexpected result: errorDescription not found");
    }
}

