/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.util.StringUtils;

public class ApplicationTypeRestrictionHttpTest
extends BaseTest {
    @Parameters(value={"redirectUris"})
    @Test
    public void omittedApplicationType(String redirectUris) throws Exception {
        this.showTitle("omittedApplicationType");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse registerResponse = registerClient.execRegister(null, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        ApplicationTypeRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        ApplicationTypeRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString())), (String)ApplicationType.WEB.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
    }

    @Parameters(value={"redirectUris"})
    @Test
    public void applicationTypeWeb(String redirectUris) throws Exception {
        this.showTitle("applicationTypeWeb");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse registerResponse = registerClient.execRegister(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        ApplicationTypeRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        ApplicationTypeRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString())), (String)ApplicationType.WEB.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
    }

    @Test
    public void applicationTypeWebFail1() throws Exception {
        this.showTitle("applicationTypeWebFail1");
        String redirectUris = "http://client.example.com/cb";
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse registerResponse = registerClient.execRegister(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)"http://client.example.com/cb"));
        ApplicationTypeRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)400, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)registerResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)registerResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Test
    public void applicationTypeWebFail2() throws Exception {
        this.showTitle("applicationTypeWebFail2");
        String redirectUris = "https://localhost/cb";
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse registerResponse = registerClient.execRegister(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)"https://localhost/cb"));
        ApplicationTypeRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)400, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)registerResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)registerResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Test
    public void applicationTypeNative() throws Exception {
        this.showTitle("applicationTypeNative");
        String redirectUris = "http://localhost/cb";
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse registerResponse = registerClient.execRegister(ApplicationType.NATIVE, "oxAuth test app", StringUtils.spaceSeparatedToList((String)"http://localhost/cb"));
        ApplicationTypeRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String registrationAccessToken = registerResponse.getRegistrationAccessToken();
        String registrationClientUri = registerResponse.getRegistrationClientUri();
        RegisterRequest readClientRequest = new RegisterRequest(registrationAccessToken);
        RegisterClient readClient = new RegisterClient(registrationClientUri);
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        ApplicationTypeRestrictionHttpTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertEquals((String)((String)readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString())), (String)ApplicationType.NATIVE.toString());
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.RESPONSE_TYPES.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.REDIRECT_URIS.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(readClientResponse.getClaims().get("scopes"));
    }

    @Test
    public void applicationTypeNativeFail1() throws Exception {
        this.showTitle("applicationTypeNativeFail1");
        String redirectUris = "https://client.example.com/cb";
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse registerResponse = registerClient.execRegister(ApplicationType.NATIVE, "oxAuth test app", StringUtils.spaceSeparatedToList((String)"https://client.example.com/cb"));
        ApplicationTypeRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)400, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)registerResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)registerResponse.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"redirectUris"})
    @Test
    public void applicationTypeNativeFail2(String redirectUris) throws Exception {
        this.showTitle("applicationTypeNativeFail2");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse registerResponse = registerClient.execRegister(ApplicationType.NATIVE, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        ApplicationTypeRestrictionHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)400, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)registerResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)registerResponse.getErrorDescription(), (String)"The error description is null");
    }
}

