/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.load.benchmark;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.testng.Assert;
import org.testng.annotations.Listeners;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.OpenIdConfigurationClient;
import org.xdi.oxauth.client.OpenIdConfigurationResponse;
import org.xdi.oxauth.load.benchmark.BenchmarkTestListener;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;

@Listeners(value={BenchmarkTestListener.class})
public class BenchmarkAuthorizatoinRequests {
    @Test
    public void testDiscovery() throws Exception {
        OpenIdConfigurationClient client = new OpenIdConfigurationClient("https://pcy28751:8443/oxauth/.well-known/openid-configuration");
        client.setExecutor((ClientExecutor)new ApacheHttpClient4Executor(BenchmarkAuthorizatoinRequests.createHttpClientTrustAll()));
        OpenIdConfigurationResponse r = client.execOpenIdConfiguration();
        Assert.assertNotNull((Object)r);
    }

    @Parameters(value={"userId", "userSecret", "redirectUri", "clientId"})
    @Test(invocationCount=2000, threadPoolSize=10)
    public void testAuthentication(String userId, String userSecret, String redirectUri, String clientId) throws Exception {
        String authorizationEndpoint = "https://pcy28751:8443/oxauth/seam/resource/restv1/oxauth/authorize";
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        responseTypes.add(ResponseType.ID_TOKEN);
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "STATE_XYZ";
        String nonce = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        request.setState(state);
        request.setNonce(nonce);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(authorizationEndpoint);
        authorizeClient.setExecutor((ClientExecutor)new ApacheHttpClient4Executor(BenchmarkAuthorizatoinRequests.createHttpClientTrustAll()));
        authorizeClient.setRequest(request);
        AuthorizationResponse response = authorizeClient.exec();
        Assert.assertNotNull((Object)response.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)response.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)response.getScope(), (String)"The scope must be null");
    }

    public static HttpClient createHttpClientTrustAll() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        SSLSocketFactory sf = new SSLSocketFactory(new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }, (X509HostnameVerifier)new AllowAllHostnameVerifier());
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 8080, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 8443, (SchemeSocketFactory)sf));
        PoolingClientConnectionManager ccm = new PoolingClientConnectionManager(registry);
        return new DefaultHttpClient((ClientConnectionManager)ccm);
    }
}

