/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.model.authorize.Claim;
import org.xdi.oxauth.client.model.authorize.ClaimValue;
import org.xdi.oxauth.client.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.oxauth.model.util.StringUtils;

public class SupportRequestFile
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "sectorIdentifierUri", "requestFileBasePath", "requestFileBaseUrl"})
    @Test
    public void requestFileMethod(String userId, String userSecret, String redirectUri, String redirectUris, String sectorIdentifierUri, String requestFileBasePath, String requestFileBaseUrl) throws Exception {
        this.showTitle("OC5:FeatureTest-Support Request File");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        SupportRequestFile.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "STATE_XYZ";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        try {
            JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret);
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("name", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("nickname", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("email_verified", ClaimValue.createNull()));
            jwtAuthorizationRequest.addUserInfoClaim(new Claim("picture", ClaimValue.createEssential((boolean)false)));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("auth_time", ClaimValue.createNull()));
            jwtAuthorizationRequest.addIdTokenClaim(new Claim("acr", ClaimValue.createValueList((String[])new String[]{"2"})));
            jwtAuthorizationRequest.getIdTokenMember().setMaxAge(Integer.valueOf(86400));
            String authJwt = jwtAuthorizationRequest.getEncodedJwt();
            String hash = JwtUtil.base64urlencode((byte[])JwtUtil.getMessageDigestSHA256((String)authJwt));
            String fileName = UUID.randomUUID().toString() + ".txt";
            String filePath = requestFileBasePath + File.separator + fileName;
            String fileUrl = requestFileBaseUrl + "/" + fileName;
            FileWriter fw = new FileWriter(filePath);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(authJwt);
            bw.close();
            fw.close();
            authorizationRequest.setRequestUri(fileUrl);
            System.out.println("Request JWT: " + authJwt);
            System.out.println("Request File Path: " + filePath);
            System.out.println("Request File URL: " + fileUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken());
        Assert.assertNotNull((Object)authorizationResponse.getState());
    }
}

