/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.util.StringUtils;

public class SupportRegistrationRead
extends BaseTest {
    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "sectorIdentifierUri"})
    @Test
    public void supportRegistrationRead(String redirectUris, String redirectUri, String userId, String userSecret, String sectorIdentifierUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Support Registration Read");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        RegisterRequest registerRequest1 = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest1.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest1.setLogoUri("http://www.gluu.org/wp-content/themes/gluursn/images/logo.png");
        registerRequest1.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest1.setPolicyUri("http://www.gluu.org/policy");
        registerRequest1.setJwksUri("http://www.gluu.org/jwks");
        registerRequest1.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest1.setSubjectType(SubjectType.PUBLIC);
        registerRequest1.setRequestObjectSigningAlg(SignatureAlgorithm.RS256);
        registerRequest1.setRequestUris(Arrays.asList("http://www.gluu.org/request"));
        RegisterClient registerClient1 = new RegisterClient(this.registrationEndpoint);
        registerClient1.setRequest(registerRequest1);
        RegisterResponse registerResponse1 = registerClient1.exec();
        SupportRegistrationRead.showClient((BaseClient)registerClient1);
        Assert.assertEquals((int)registerResponse1.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse1.getEntity()));
        Assert.assertNotNull((Object)registerResponse1.getClientId());
        Assert.assertNotNull((Object)registerResponse1.getClientSecret());
        Assert.assertNotNull((Object)registerResponse1.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse1.getClientSecretExpiresAt());
        Assert.assertNotNull(registerResponse1.getClaims().get(RegisterRequestParam.SCOPES.toString()));
        String clientId = registerResponse1.getClientId();
        String registrationAccessToken = registerResponse1.getRegistrationAccessToken();
        String registrationClientUri = registerResponse1.getRegistrationClientUri();
        RegisterRequest registerRequest2 = new RegisterRequest(registrationAccessToken);
        RegisterClient registerClient2 = new RegisterClient(registrationClientUri);
        registerClient2.setRequest(registerRequest2);
        RegisterResponse registerResponse2 = registerClient2.exec();
        SupportRegistrationRead.showClient((BaseClient)registerClient2);
        Assert.assertEquals((int)registerResponse2.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse2.getEntity()));
        Assert.assertNotNull((Object)registerResponse2.getClientId());
        Assert.assertNotNull((Object)registerResponse2.getClientSecret());
        Assert.assertNotNull((Object)registerResponse2.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse2.getRegistrationClientUri());
        Assert.assertNotNull((Object)registerResponse2.getClientSecretExpiresAt());
        Assert.assertNotNull(registerResponse2.getClaims().get(RegisterRequestParam.APPLICATION_TYPE.toString()));
        Assert.assertNotNull(registerResponse2.getClaims().get(RegisterRequestParam.POLICY_URI.toString()));
        Assert.assertNotNull(registerResponse2.getClaims().get(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString()));
        Assert.assertNotNull(registerResponse2.getClaims().get(RegisterRequestParam.CONTACTS.toString()));
        Assert.assertNotNull(registerResponse2.getClaims().get(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString()));
        Assert.assertNotNull(registerResponse2.getClaims().get(RegisterRequestParam.SUBJECT_TYPE.toString()));
        Assert.assertNotNull(registerResponse2.getClaims().get(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
        Assert.assertNotNull(registerResponse2.getClaims().get(RegisterRequestParam.JWKS_URI.toString()));
        Assert.assertNotNull(registerResponse2.getClaims().get(RegisterRequestParam.CLIENT_NAME.toString()));
        Assert.assertNotNull(registerResponse2.getClaims().get(RegisterRequestParam.LOGO_URI.toString()));
        Assert.assertNotNull(registerResponse2.getClaims().get(RegisterRequestParam.REQUEST_URIS.toString()));
        Assert.assertNotNull(registerResponse2.getClaims().get("scopes"));
    }
}

