/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class RejectsSecondUseOfAccessCode
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri"})
    @Test
    public void rejectsSecondUseOfAccessCode(String userId, String userSecret, String redirectUris, String redirectUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Rejects Second Use of Access Code");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        RejectsSecondUseOfAccessCode.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token is null");
        String scope = authorizationResponse.getScope();
        String authorizationCode = authorizationResponse.getCode();
        String accessToken = null;
        String refreshToken = null;
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        TokenResponse tokenResponse = tokenClient.execAuthorizationCode(authorizationCode, redirectUri, clientId, clientSecret);
        RejectsSecondUseOfAccessCode.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse.getRefreshToken(), (String)"The refresh token is null");
        accessToken = tokenResponse.getAccessToken();
        refreshToken = tokenResponse.getRefreshToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        RejectsSecondUseOfAccessCode.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
        tokenClient = new TokenClient(this.tokenEndpoint);
        tokenResponse = tokenClient.execAuthorizationCode(authorizationCode, redirectUri, clientId, clientSecret);
        RejectsSecondUseOfAccessCode.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)tokenResponse.getStatus(), (int)400, (String)("Unexpected response code: " + tokenResponse.getStatus()));
        Assert.assertNotNull((Object)tokenResponse.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)tokenResponse.getErrorDescription(), (String)"The error description is null");
    }
}

