/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class DisplaysPolicyUriInLoginPage
extends BaseTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Parameters(value={"redirectUris", "redirectUri"})
    @Test
    public void displaysPolicyUrlInLoginPage(String redirectUris, String redirectUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Displays Policy in Login Page");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        String policyUri = "http://www.gluu.org/policy";
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setPolicyUri(policyUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        DisplaysPolicyUriInLoginPage.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
        authorizationRequest.setState(state);
        String authorizationRequestUrl = this.getAuthorizationEndpoint() + "?" + authorizationRequest.getQueryString();
        AuthorizeClient authorizeClient = new AuthorizeClient(this.getAuthorizationEndpoint());
        authorizeClient.setRequest(authorizationRequest);
        try {
            this.startSelenium();
            this.driver.navigate().to(authorizationRequestUrl);
            WebElement policy = this.driver.findElement(By.xpath((String)("//a[@href='" + policyUri + "']")));
            Assert.assertNotNull((Object)policy);
        }
        catch (NoSuchElementException ex) {
            Assert.fail((String)"Policy not found");
        }
        finally {
            this.stopSelenium();
        }
    }
}

