/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.Arrays;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.dev.HostnameVerifierType;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class SSOWithMultipleBackendServicesHttpTest
extends BaseTest {
    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri", "hostnameVerifier"})
    @Test
    public void sessionWorkFlow1(String redirectUris, String userId, String userSecret, String redirectUri, String hostnameVerifier) throws Exception {
        this.showTitle("sessionWorkFlow1");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        DefaultHttpClient httpClient = SSOWithMultipleBackendServicesHttpTest.createHttpClient(HostnameVerifierType.fromString(hostnameVerifier));
        BasicCookieStore cookieStore = new BasicCookieStore();
        httpClient.setCookieStore((CookieStore)cookieStore);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor((HttpClient)httpClient);
        AuthorizationRequest authorizationRequest1 = new AuthorizationRequest(Arrays.asList(ResponseType.CODE), clientId, Arrays.asList("openid", "profile", "email"), redirectUri, null);
        authorizationRequest1.setAuthUsername(userId);
        authorizationRequest1.setAuthPassword(userSecret);
        authorizationRequest1.getPrompts().add(Prompt.NONE);
        authorizationRequest1.setState("af0ifjsldkj");
        authorizationRequest1.setRequestSessionId(true);
        AuthorizeClient authorizeClient1 = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient1.setRequest(authorizationRequest1);
        AuthorizationResponse authorizationResponse1 = authorizeClient1.exec((ClientExecutor)clientExecutor);
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)authorizeClient1);
        Assert.assertEquals((int)authorizationResponse1.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse1.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse1.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse1.getSessionId(), (String)"The sessionId is null");
        Assert.assertNotNull((Object)authorizationResponse1.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse1.getScope(), (String)"The scope is null");
        String code1 = authorizationResponse1.getCode();
        String sessionId = authorizationResponse1.getSessionId();
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        TokenResponse tokenResponse1 = tokenClient1.execAuthorizationCode(code1, redirectUri, clientId, clientSecret);
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)tokenResponse1.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse1.getStatus()));
        Assert.assertNotNull((Object)tokenResponse1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse1.getRefreshToken(), (String)"The refresh token is null");
        String accessToken1 = tokenResponse1.getAccessToken();
        UserInfoClient userInfoClient1 = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse1 = userInfoClient1.execUserInfo(accessToken1);
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)userInfoClient1);
        Assert.assertEquals((int)userInfoResponse1.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse1.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse1.getClaim("sub"), (String)"Unexpected result: subject not found");
        Assert.assertNotNull((Object)userInfoResponse1.getClaim("name"), (String)"Unexpected result: name not found");
        Assert.assertNotNull((Object)userInfoResponse1.getClaim("given_name"), (String)"Unexpected result: given_name not found");
        Assert.assertNotNull((Object)userInfoResponse1.getClaim("family_name"), (String)"Unexpected result: family_name not found");
        Assert.assertNotNull((Object)userInfoResponse1.getClaim("email"), (String)"Unexpected result: email not found");
        AuthorizationRequest authorizationRequest2 = new AuthorizationRequest(Arrays.asList(ResponseType.CODE), clientId, Arrays.asList("openid", "profile", "email"), redirectUri, null);
        authorizationRequest2.getPrompts().add(Prompt.NONE);
        authorizationRequest2.setState("af0ifjsldkj");
        authorizationRequest2.setSessionId(sessionId);
        AuthorizeClient authorizeClient2 = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient2.setRequest(authorizationRequest2);
        AuthorizationResponse authorizationResponse2 = authorizeClient2.exec((ClientExecutor)clientExecutor);
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)authorizeClient2);
        Assert.assertEquals((int)authorizationResponse2.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse2.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse2.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse2.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse2.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse2.getScope(), (String)"The scope is null");
        String code2 = authorizationResponse2.getCode();
        TokenClient tokenClient2 = new TokenClient(this.tokenEndpoint);
        TokenResponse tokenResponse2 = tokenClient2.execAuthorizationCode(code2, redirectUri, clientId, clientSecret);
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)tokenClient2);
        Assert.assertEquals((int)tokenResponse2.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse2.getStatus()));
        Assert.assertNotNull((Object)tokenResponse2.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse2.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse2.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse2.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse2.getRefreshToken(), (String)"The refresh token is null");
        String accessToken2 = tokenResponse2.getAccessToken();
        UserInfoClient userInfoClient2 = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse2 = userInfoClient2.execUserInfo(accessToken2);
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)userInfoClient2);
        Assert.assertEquals((int)userInfoResponse2.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse2.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse2.getClaim("sub"), (String)"Unexpected result: subject not found");
        Assert.assertNotNull((Object)userInfoResponse2.getClaim("name"), (String)"Unexpected result: name not found");
        Assert.assertNotNull((Object)userInfoResponse2.getClaim("given_name"), (String)"Unexpected result: given_name not found");
        Assert.assertNotNull((Object)userInfoResponse2.getClaim("family_name"), (String)"Unexpected result: family_name not found");
        Assert.assertNotNull((Object)userInfoResponse2.getClaim("email"), (String)"Unexpected result: email not found");
    }

    @Parameters(value={"redirectUris", "redirectUri", "userInum", "userEmail", "hostnameVerifier"})
    @Test
    public void sessionWorkFlow2(String redirectUris, String redirectUri, String userInum, String userEmail, String hostnameVerifier) throws Exception {
        this.showTitle("sessionWorkFlow2");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        DefaultHttpClient httpClient = SSOWithMultipleBackendServicesHttpTest.createHttpClient(HostnameVerifierType.fromString(hostnameVerifier));
        BasicCookieStore cookieStore = new BasicCookieStore();
        httpClient.setCookieStore((CookieStore)cookieStore);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor((HttpClient)httpClient);
        AuthorizationRequest authorizationRequest1 = new AuthorizationRequest(Arrays.asList(ResponseType.CODE), clientId, Arrays.asList("openid", "profile", "email"), redirectUri, null);
        authorizationRequest1.addCustomParameter("mail", userEmail);
        authorizationRequest1.addCustomParameter("inum", userInum);
        authorizationRequest1.getPrompts().add(Prompt.NONE);
        authorizationRequest1.setState("af0ifjsldkj");
        authorizationRequest1.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
        authorizationRequest1.setRequestSessionId(true);
        AuthorizeClient authorizeClient1 = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient1.setRequest(authorizationRequest1);
        AuthorizationResponse authorizationResponse1 = authorizeClient1.exec((ClientExecutor)clientExecutor);
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)authorizeClient1);
        Assert.assertEquals((int)authorizationResponse1.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse1.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse1.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse1.getSessionId(), (String)"The session id is null");
        Assert.assertNotNull((Object)authorizationResponse1.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse1.getScope(), (String)"The scope is null");
        String authorizationCode1 = authorizationResponse1.getCode();
        String sessionId = authorizationResponse1.getSessionId();
        TokenRequest tokenRequest1 = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest1.setCode(authorizationCode1);
        tokenRequest1.setRedirectUri(redirectUri);
        tokenRequest1.setAuthUsername(clientId);
        tokenRequest1.setAuthPassword(clientSecret);
        tokenRequest1.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        tokenClient1.setRequest(tokenRequest1);
        TokenResponse tokenResponse1 = tokenClient1.exec();
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)tokenResponse1.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse1.getStatus()));
        Assert.assertNotNull((Object)tokenResponse1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse1.getRefreshToken(), (String)"The refresh token is null");
        AuthorizationRequest authorizationRequest2 = new AuthorizationRequest(Arrays.asList(ResponseType.CODE), clientId, Arrays.asList("openid", "profile", "email"), redirectUri, null);
        authorizationRequest2.getPrompts().add(Prompt.NONE);
        authorizationRequest2.setState("af0ifjsldkj");
        authorizationRequest2.setSessionId(sessionId);
        AuthorizeClient authorizeClient2 = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient2.setRequest(authorizationRequest2);
        AuthorizationResponse authorizationResponse2 = authorizeClient2.exec((ClientExecutor)clientExecutor);
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)authorizeClient2);
        Assert.assertEquals((int)authorizationResponse2.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse2.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse2.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse2.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse2.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse2.getScope(), (String)"The scope is null");
        String authorizationCode2 = authorizationResponse2.getCode();
        TokenRequest tokenRequest2 = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest2.setCode(authorizationCode2);
        tokenRequest2.setRedirectUri(redirectUri);
        tokenRequest2.setAuthUsername(clientId);
        tokenRequest2.setAuthPassword(clientSecret);
        tokenRequest2.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient2 = new TokenClient(this.tokenEndpoint);
        tokenClient2.setRequest(tokenRequest2);
        TokenResponse tokenResponse2 = tokenClient2.exec();
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)tokenClient2);
        Assert.assertEquals((int)tokenResponse2.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse2.getStatus()));
        Assert.assertNotNull((Object)tokenResponse2.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse2.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse2.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse2.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse2.getRefreshToken(), (String)"The refresh token is null");
        AuthorizationRequest authorizationRequest3 = new AuthorizationRequest(Arrays.asList(ResponseType.CODE), clientId, Arrays.asList("openid", "profile", "email"), redirectUri, null);
        authorizationRequest3.getPrompts().add(Prompt.NONE);
        authorizationRequest3.setState("af0ifjsldkj");
        authorizationRequest3.setSessionId(sessionId);
        AuthorizeClient authorizeClient3 = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient3.setRequest(authorizationRequest3);
        AuthorizationResponse authorizationResponse3 = authorizeClient2.exec((ClientExecutor)clientExecutor);
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)authorizeClient3);
        Assert.assertEquals((int)authorizationResponse3.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse3.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse3.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse3.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse3.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse3.getScope(), (String)"The scope is null");
        String authorizationCode3 = authorizationResponse3.getCode();
        TokenRequest tokenRequest3 = new TokenRequest(GrantType.AUTHORIZATION_CODE);
        tokenRequest3.setCode(authorizationCode3);
        tokenRequest3.setRedirectUri(redirectUri);
        tokenRequest3.setAuthUsername(clientId);
        tokenRequest3.setAuthPassword(clientSecret);
        tokenRequest3.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_POST);
        TokenClient tokenClient3 = new TokenClient(this.tokenEndpoint);
        tokenClient3.setRequest(tokenRequest3);
        TokenResponse tokenResponse3 = tokenClient3.exec();
        SSOWithMultipleBackendServicesHttpTest.showClient((BaseClient)tokenClient3);
        Assert.assertEquals((int)tokenResponse3.getStatus(), (int)200, (String)("Unexpected response code: " + tokenResponse3.getStatus()));
        Assert.assertNotNull((Object)tokenResponse3.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)tokenResponse3.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)tokenResponse3.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)tokenResponse3.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)tokenResponse3.getRefreshToken(), (String)"The refresh token is null");
    }
}

