/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.IdClient;
import org.xdi.oxauth.client.uma.RequesterPermissionTokenService;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.wrapper.UmaClient;
import org.xdi.oxauth.model.common.Id;
import org.xdi.oxauth.model.common.IdType;
import org.xdi.oxauth.model.uma.MetadataConfiguration;
import org.xdi.oxauth.model.uma.RequesterPermissionTokenResponse;
import org.xdi.oxauth.model.uma.ResourceSetPermissionTicket;
import org.xdi.oxauth.model.uma.RptAuthorizationRequest;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;

public class IdGenWsHttpTest
extends BaseTest {
    protected Token m_aat;
    protected String m_rpt;
    protected MetadataConfiguration m_metadataConfiguration;
    protected String m_umaAmHost;

    @BeforeClass
    @Parameters(value={"umaMetaDataUrl", "umaAatClientId", "umaAatClientSecret", "umaAmHost"})
    public void init(String umaMetaDataUrl, String umaAatClientId, String umaAatClientSecret, String umaAmHost) throws Exception {
        this.m_metadataConfiguration = UmaClientFactory.instance().createMetaDataConfigurationService(umaMetaDataUrl).getMetadataConfiguration();
        UmaTestUtil.assert_((MetadataConfiguration)this.m_metadataConfiguration);
        this.m_umaAmHost = umaAmHost;
        this.m_aat = UmaClient.requestAat((String)this.tokenEndpoint, (String)umaAatClientId, (String)umaAatClientSecret);
        UmaTestUtil.assert_((Token)this.m_aat);
        RequesterPermissionTokenService rptService = UmaClientFactory.instance().createRequesterPermissionTokenService(this.m_metadataConfiguration);
        RequesterPermissionTokenResponse requesterPermissionTokenResponse = null;
        try {
            requesterPermissionTokenResponse = rptService.getRequesterPermissionToken("Bearer " + this.m_aat.getAccessToken(), umaAmHost);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        UmaTestUtil.assert_((RequesterPermissionTokenResponse)requesterPermissionTokenResponse);
        this.m_rpt = requesterPermissionTokenResponse.getToken();
    }

    @Test
    public void test() {
        String prefix = "@!1111";
        try {
            Id clientId = IdClient.generateIdWithRpt((String)this.getIdGenEndpoint(), (String)"@!1111", (IdType)IdType.CLIENTS, (String)this.m_rpt);
            Assert.assertTrue((boolean)false);
        }
        catch (ClientResponseFailure e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)403);
            BaseClientResponse r = (BaseClientResponse)e.getResponse();
            r.setReturnType(ResourceSetPermissionTicket.class);
            ResourceSetPermissionTicket ticket = (ResourceSetPermissionTicket)r.getEntity();
            UmaTestUtil.assert_((ResourceSetPermissionTicket)ticket);
            this.authorizeRpt(ticket.getTicket());
            Id clientId = IdClient.generateIdWithRpt((String)this.getIdGenEndpoint(), (String)"@!1111", (IdType)IdType.CLIENTS, (String)this.m_rpt);
            System.out.println("Client generated ID: " + clientId);
            Assert.assertTrue((clientId != null && StringUtils.isNotBlank((String)clientId.getId()) && clientId.getId().startsWith("@!1111") ? 1 : 0) != 0);
            Id peopleId = IdClient.generateIdWithRpt((String)this.getIdGenEndpoint(), (String)"@!1111", (IdType)IdType.PEOPLE, (String)this.m_rpt);
            System.out.println("People generated ID: " + peopleId);
            Assert.assertTrue((peopleId != null && StringUtils.isNotBlank((String)peopleId.getId()) && peopleId.getId().startsWith("@!1111") ? 1 : 0) != 0);
        }
    }

    private void authorizeRpt(String p_ticket) {
        ClientResponse authorizationResponse = null;
        try {
            RptAuthorizationRequest rptAuthorizationRequest = new RptAuthorizationRequest(this.m_rpt, p_ticket);
            authorizationResponse = UmaClientFactory.instance().createAuthorizationRequestService(this.m_metadataConfiguration).requestRptPermissionAuthorization("Bearer " + this.m_aat.getAccessToken(), this.m_umaAmHost, rptAuthorizationRequest);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        UmaTestUtil.assertAuthorizationRequest((ClientResponse)authorizationResponse);
    }
}

