/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import org.testng.Assert;
import org.testng.annotations.Test;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryRequest;

public class CanDiscoverIdentifiersUsingUrlSyntax {
    @Test
    public void urlNormalization1() throws Exception {
        String resource = "https://example.com";
        String expectedHost = "example.com";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void urlNormalization2() throws Exception {
        String resource = "https://example.com/joe";
        String expectedHost = "example.com";
        String expectedPath = "/joe";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }

    @Test
    public void urlNormalization3() throws Exception {
        String resource = "https://example.com:8080/";
        String expectedHost = "example.com:8080";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void urlNormalization4() throws Exception {
        String resource = "https://example.com:8080/joe";
        String expectedHost = "example.com:8080";
        String expectedPath = "/joe";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }

    @Test
    public void urlNormalization5() throws Exception {
        String resource = "https://example.com:8080/joe#fragment";
        String expectedHost = "example.com:8080";
        String expectedPath = "/joe";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }

    @Test
    public void urlNormalization6() throws Exception {
        String resource = "https://example.com:8080/joe?param=value";
        String expectedHost = "example.com:8080";
        String expectedPath = "/joe";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }

    @Test
    public void urlNormalization7() throws Exception {
        String resource = "https://example.com:8080/joe?param1=foo&param2=bar#fragment";
        String expectedHost = "example.com:8080";
        String expectedPath = "/joe";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }

    @Test
    public void hostNormalization1() throws Exception {
        String resource = "example.com";
        String expectedHost = "example.com";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void hostNormalization2() throws Exception {
        String resource = "example.com:8080";
        String expectedHost = "example.com:8080";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void hostNormalization3() throws Exception {
        String resource = "example.com/path";
        String expectedHost = "example.com";
        String expectedPath = "/path";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }

    @Test
    public void hostNormalization4() throws Exception {
        String resource = "example.com:8080/path";
        String expectedHost = "example.com:8080";
        String expectedPath = "/path";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }
}

