/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth;

import com.google.common.base.Function;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.BaseResponseWithErrors;
import org.xdi.oxauth.client.ClientUtils;
import org.xdi.oxauth.client.OpenIdConfigurationClient;
import org.xdi.oxauth.client.OpenIdConfigurationResponse;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryClient;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryResponse;
import org.xdi.oxauth.dev.HostnameVerifierType;
import org.xdi.oxauth.model.discovery.WebFingerLink;
import org.xdi.oxauth.model.error.IErrorType;

public abstract class BaseTest {
    protected WebDriver driver;
    protected String authorizationEndpoint;
    protected String tokenEndpoint;
    protected String userInfoEndpoint;
    protected String clientInfoEndpoint;
    protected String checkSessionIFrame;
    protected String endSessionEndpoint;
    protected String jwksUri;
    protected String registrationEndpoint;
    protected String validateTokenEndpoint;
    protected String federationMetadataEndpoint;
    protected String federationEndpoint;
    protected String configurationEndpoint;
    protected String idGenEndpoint;
    protected String introspectionEndpoint;
    protected Map<String, List<String>> scopeToClaimsMapping;
    private String loginFormUsername;
    private String loginFormPassword;
    private String loginFormLoginButton;
    private String authorizeFormAllowButton;
    private String authorizeFormDoNotAllowButton;

    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public String getClientInfoEndpoint() {
        return this.clientInfoEndpoint;
    }

    public void setClientInfoEndpoint(String clientInfoEndpoint) {
        this.clientInfoEndpoint = clientInfoEndpoint;
    }

    public String getCheckSessionIFrame() {
        return this.checkSessionIFrame;
    }

    public void setCheckSessionIFrame(String checkSessionIFrame) {
        this.checkSessionIFrame = checkSessionIFrame;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getRegistrationEndpoint() {
        return this.registrationEndpoint;
    }

    public void setRegistrationEndpoint(String registrationEndpoint) {
        this.registrationEndpoint = registrationEndpoint;
    }

    public String getValidateTokenEndpoint() {
        return this.validateTokenEndpoint;
    }

    public void setValidateTokenEndpoint(String validateTokenEndpoint) {
        this.validateTokenEndpoint = validateTokenEndpoint;
    }

    public String getFederationMetadataEndpoint() {
        return this.federationMetadataEndpoint;
    }

    public void setFederationMetadataEndpoint(String federationMetadataEndpoint) {
        this.federationMetadataEndpoint = federationMetadataEndpoint;
    }

    public String getFederationEndpoint() {
        return this.federationEndpoint;
    }

    public void setFederationEndpoint(String federationEndpoint) {
        this.federationEndpoint = federationEndpoint;
    }

    public String getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    public void setIntrospectionEndpoint(String p_introspectionEndpoint) {
        this.introspectionEndpoint = p_introspectionEndpoint;
    }

    public Map<String, List<String>> getScopeToClaimsMapping() {
        return this.scopeToClaimsMapping;
    }

    public void setScopeToClaimsMapping(Map<String, List<String>> p_scopeToClaimsMapping) {
        this.scopeToClaimsMapping = p_scopeToClaimsMapping;
    }

    public String getIdGenEndpoint() {
        return this.idGenEndpoint;
    }

    public void setIdGenEndpoint(String p_idGenEndpoint) {
        this.idGenEndpoint = p_idGenEndpoint;
    }

    public String getConfigurationEndpoint() {
        return this.configurationEndpoint;
    }

    public void setConfigurationEndpoint(String configurationEndpoint) {
        this.configurationEndpoint = configurationEndpoint;
    }

    public void startSelenium() {
        this.driver = new HtmlUnitDriver();
    }

    public void stopSelenium() {
        this.driver.close();
        this.driver.quit();
    }

    public AuthorizationResponse authenticateResourceOwnerAndGrantAccess(String authorizeUrl, AuthorizationRequest authorizationRequest, String userId, String userSecret) {
        String authorizationRequestUrl = authorizeUrl + "?" + authorizationRequest.getQueryString();
        AuthorizeClient authorizeClient = new AuthorizeClient(authorizeUrl);
        authorizeClient.setRequest(authorizationRequest);
        this.startSelenium();
        this.deleteAllCookies();
        this.driver.navigate().to(authorizationRequestUrl);
        WebElement usernameElement = this.driver.findElement(By.name((String)this.loginFormUsername));
        WebElement passwordElement = this.driver.findElement(By.name((String)this.loginFormPassword));
        WebElement loginButton = this.driver.findElement(By.name((String)this.loginFormLoginButton));
        usernameElement.sendKeys(new CharSequence[]{userId});
        passwordElement.sendKeys(new CharSequence[]{userSecret});
        loginButton.click();
        String authorizationResponseStr = this.driver.getCurrentUrl();
        if (authorizationRequest.getRedirectUri() == null || !authorizationResponseStr.startsWith(authorizationRequest.getRedirectUri())) {
            WebElement allowButton = this.driver.findElement(By.name((String)this.authorizeFormAllowButton));
            WebElement doNotAllowButton = this.driver.findElement(By.name((String)this.authorizeFormDoNotAllowButton));
            final String previousURL = this.driver.getCurrentUrl();
            allowButton.click();
            WebDriverWait wait = new WebDriverWait(this.driver, 10L);
            wait.until((Function)new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver d) {
                    return d.getCurrentUrl() != previousURL;
                }
            });
            authorizationResponseStr = this.driver.getCurrentUrl();
        }
        this.stopSelenium();
        AuthorizationResponse authorizationResponse = new AuthorizationResponse(authorizationResponseStr);
        authorizeClient.setResponse(authorizationResponse);
        BaseTest.showClientUserAgent((BaseClient)authorizeClient);
        return authorizationResponse;
    }

    private void deleteAllCookies() {
        try {
            this.driver.manage().deleteAllCookies();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @BeforeTest
    public void discovery(ITestContext context) throws Exception {
        this.loginFormUsername = context.getCurrentXmlTest().getParameter("loginFormUsername");
        this.loginFormPassword = context.getCurrentXmlTest().getParameter("loginFormPassword");
        this.loginFormLoginButton = context.getCurrentXmlTest().getParameter("loginFormLoginButton");
        this.authorizeFormAllowButton = context.getCurrentXmlTest().getParameter("authorizeFormAllowButton");
        this.authorizeFormDoNotAllowButton = context.getCurrentXmlTest().getParameter("authorizeFormDoNotAllowButton");
        String resource = context.getCurrentXmlTest().getParameter("swdResource");
        if (StringUtils.isNotBlank((String)resource)) {
            this.showTitle("OpenID Connect Discovery");
            OpenIdConnectDiscoveryClient openIdConnectDiscoveryClient = new OpenIdConnectDiscoveryClient(resource);
            OpenIdConnectDiscoveryResponse openIdConnectDiscoveryResponse = openIdConnectDiscoveryClient.exec((ClientExecutor)new ApacheHttpClient4Executor((HttpClient)BaseTest.createHttpClient(HostnameVerifierType.ALLOW_ALL)));
            BaseTest.showClient((BaseClient)openIdConnectDiscoveryClient);
            Assert.assertEquals((int)openIdConnectDiscoveryResponse.getStatus(), (int)200, (String)"Unexpected response code");
            Assert.assertNotNull((Object)openIdConnectDiscoveryResponse.getSubject());
            Assert.assertTrue((openIdConnectDiscoveryResponse.getLinks().size() > 0 ? 1 : 0) != 0);
            this.configurationEndpoint = ((WebFingerLink)openIdConnectDiscoveryResponse.getLinks().get(0)).getHref() + "/.well-known/openid-configuration";
            System.out.println("OpenID Connect Configuration");
            OpenIdConfigurationClient client = new OpenIdConfigurationClient(this.configurationEndpoint);
            OpenIdConfigurationResponse response = client.execOpenIdConfiguration();
            BaseTest.showClient((BaseClient)client);
            Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code");
            Assert.assertNotNull((Object)response.getIssuer(), (String)"The issuer is null");
            Assert.assertNotNull((Object)response.getAuthorizationEndpoint(), (String)"The authorizationEndpoint is null");
            Assert.assertNotNull((Object)response.getTokenEndpoint(), (String)"The tokenEndpoint is null");
            Assert.assertNotNull((Object)response.getUserInfoEndpoint(), (String)"The userInfoEndPoint is null");
            Assert.assertNotNull((Object)response.getJwksUri(), (String)"The jwksUri is null");
            Assert.assertNotNull((Object)response.getRegistrationEndpoint(), (String)"The registrationEndpoint is null");
            Assert.assertTrue((response.getScopesSupported().size() > 0 ? 1 : 0) != 0, (String)"The scopesSupported is empty");
            Assert.assertTrue((response.getScopeToClaimsMapping().size() > 0 ? 1 : 0) != 0, (String)"The scope to claims mapping is empty");
            Assert.assertTrue((response.getResponseTypesSupported().size() > 0 ? 1 : 0) != 0, (String)"The responseTypesSupported is empty");
            Assert.assertTrue((response.getGrantTypesSupported().size() > 0 ? 1 : 0) != 0, (String)"The grantTypesSupported is empty");
            Assert.assertTrue((response.getAcrValuesSupported().size() == 0 ? 1 : 0) != 0, (String)"The acrValuesSupported is not empty");
            Assert.assertTrue((response.getAmrValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The amrValuesSupported is empty");
            Assert.assertTrue((response.getSubjectTypesSupported().size() > 0 ? 1 : 0) != 0, (String)"The subjectTypesSupported is empty");
            Assert.assertTrue((response.getIdTokenSigningAlgValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The idTokenSigningAlgValuesSupported is empty");
            Assert.assertTrue((response.getRequestObjectSigningAlgValuesSupported().size() > 0 ? 1 : 0) != 0, (String)"The requestObjectSigningAlgValuesSupported is empty");
            Assert.assertTrue((response.getTokenEndpointAuthMethodsSupported().size() > 0 ? 1 : 0) != 0, (String)"The tokenEndpointAuthMethodsSupported is empty");
            Assert.assertTrue((response.getClaimsSupported().size() > 0 ? 1 : 0) != 0, (String)"The claimsSupported is empty");
            this.authorizationEndpoint = response.getAuthorizationEndpoint();
            this.tokenEndpoint = response.getTokenEndpoint();
            this.userInfoEndpoint = response.getUserInfoEndpoint();
            this.clientInfoEndpoint = response.getClientInfoEndpoint();
            this.checkSessionIFrame = response.getCheckSessionIFrame();
            this.endSessionEndpoint = response.getEndSessionEndpoint();
            this.jwksUri = response.getJwksUri();
            this.registrationEndpoint = response.getRegistrationEndpoint();
            this.validateTokenEndpoint = response.getValidateTokenEndpoint();
            this.federationMetadataEndpoint = response.getFederationMetadataEndpoint();
            this.federationEndpoint = response.getFederationEndpoint();
            this.idGenEndpoint = response.getIdGenerationEndpoint();
            this.introspectionEndpoint = response.getIntrospectionEndpoint();
            this.scopeToClaimsMapping = response.getScopeToClaimsMapping();
        } else {
            this.showTitle("Loading configuration endpoints from properties file");
            this.authorizationEndpoint = context.getCurrentXmlTest().getParameter("authorizationEndpoint");
            this.tokenEndpoint = context.getCurrentXmlTest().getParameter("tokenEndpoint");
            this.userInfoEndpoint = context.getCurrentXmlTest().getParameter("userInfoEndpoint");
            this.clientInfoEndpoint = context.getCurrentXmlTest().getParameter("clientInfoEndpoint");
            this.checkSessionIFrame = context.getCurrentXmlTest().getParameter("checkSessionIFrame");
            this.endSessionEndpoint = context.getCurrentXmlTest().getParameter("endSessionEndpoint");
            this.jwksUri = context.getCurrentXmlTest().getParameter("jwksUri");
            this.registrationEndpoint = context.getCurrentXmlTest().getParameter("registrationEndpoint");
            this.validateTokenEndpoint = context.getCurrentXmlTest().getParameter("validateTokenEndpoint");
            this.federationMetadataEndpoint = context.getCurrentXmlTest().getParameter("federationMetadataEndpoint");
            this.federationEndpoint = context.getCurrentXmlTest().getParameter("federationEndpoint");
            this.idGenEndpoint = context.getCurrentXmlTest().getParameter("idGenEndpoint");
            this.introspectionEndpoint = context.getCurrentXmlTest().getParameter("introspectionEndpoint");
            this.scopeToClaimsMapping = new HashMap<String, List<String>>();
        }
    }

    public void showTitle(String title) {
        title = "TEST: " + title;
        System.out.println("#######################################################");
        System.out.println(title);
        System.out.println("#######################################################");
    }

    public void showEntity(String entity) {
        if (entity != null) {
            System.out.println("Entity: " + entity.replace("\\n", "\n"));
        }
    }

    public static void showClient(BaseClient client) {
        ClientUtils.showClient((BaseClient)client);
    }

    public static void showClient(BaseClient client, CookieStore cookieStore) {
        ClientUtils.showClient((BaseClient)client, (CookieStore)cookieStore);
    }

    public static void showClientUserAgent(BaseClient client) {
        ClientUtils.showClientUserAgent((BaseClient)client);
    }

    public static void assertErrorResponse(BaseResponseWithErrors p_response, IErrorType p_errorType) {
        Assert.assertEquals((int)p_response.getStatus(), (int)400, (String)("Unexpected response code. Entity: " + p_response.getEntity()));
        Assert.assertNotNull((Object)p_response.getEntity(), (String)"The entity is null");
        Assert.assertEquals((Object)p_response.getErrorType(), (Object)p_errorType);
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)p_response.getErrorDescription()));
    }

    public static DefaultHttpClient createHttpClient() {
        return BaseTest.createHttpClient(HostnameVerifierType.DEFAULT);
    }

    public static DefaultHttpClient createHttpClient(HostnameVerifierType p_verifierType) {
        if (p_verifierType != null && p_verifierType != HostnameVerifierType.DEFAULT) {
            switch (p_verifierType) {
                case ALLOW_ALL: {
                    X509HostnameVerifier hostnameVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                    DefaultHttpClient client = new DefaultHttpClient();
                    SchemeRegistry registry = new SchemeRegistry();
                    SSLSocketFactory socketFactory = SSLSocketFactory.getSocketFactory();
                    socketFactory.setHostnameVerifier(hostnameVerifier);
                    registry.register(new Scheme("https", (SocketFactory)socketFactory, 443));
                    SingleClientConnManager mgr = new SingleClientConnManager(client.getParams(), registry);
                    HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)hostnameVerifier);
                    return new DefaultHttpClient((ClientConnectionManager)mgr, client.getParams());
                }
                case DEFAULT: {
                    return new DefaultHttpClient();
                }
            }
        }
        return new DefaultHttpClient();
    }
}

