/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.util.StringUtils;

public class RegisterRequest
extends BaseRequest {
    private String registrationAccessToken;
    private List<String> redirectUris;
    private List<ResponseType> responseTypes;
    private List<GrantType> grantTypes;
    private ApplicationType applicationType;
    private List<String> contacts;
    private String clientName;
    private String logoUri;
    private String clientUri;
    private AuthenticationMethod tokenEndpointAuthMethod;
    private String policyUri;
    private String tosUri;
    private String jwksUri;
    private String sectorIdentifierUri;
    private SubjectType subjectType;
    private SignatureAlgorithm requestObjectSigningAlg;
    private SignatureAlgorithm userInfoSignedResponseAlg;
    private KeyEncryptionAlgorithm userInfoEncryptedResponseAlg;
    private BlockEncryptionAlgorithm userInfoEncryptedResponseEnc;
    private SignatureAlgorithm idTokenSignedResponseAlg;
    private KeyEncryptionAlgorithm idTokenEncryptedResponseAlg;
    private BlockEncryptionAlgorithm idTokenEncryptedResponseEnc;
    private Integer defaultMaxAge;
    private Boolean requireAuthTime;
    private List<String> defaultAcrValues;
    private String initiateLoginUri;
    private List<String> postLogoutRedirectUris;
    private List<String> requestUris;
    private List<String> scopes;
    private String federationId;
    private String federationUrl;
    private Map<String, String> customAttributes;
    private JSONObject m_jsonObject;
    private String m_httpMethod;

    private RegisterRequest() {
        this.setContentType("application/json");
        this.setMediaType("application/json");
        this.redirectUris = new ArrayList<String>();
        this.responseTypes = new ArrayList<ResponseType>();
        this.grantTypes = new ArrayList<GrantType>();
        this.contacts = new ArrayList<String>();
        this.defaultAcrValues = new ArrayList<String>();
        this.postLogoutRedirectUris = new ArrayList<String>();
        this.requestUris = new ArrayList<String>();
        this.scopes = new ArrayList<String>();
        this.customAttributes = new HashMap<String, String>();
    }

    public RegisterRequest(ApplicationType applicationType, String clientName, List<String> redirectUris) {
        this();
        this.applicationType = applicationType;
        this.clientName = clientName;
        this.redirectUris = redirectUris;
    }

    public RegisterRequest(String registrationAccessToken) {
        this();
        this.registrationAccessToken = registrationAccessToken;
    }

    public String getRegistrationAccessToken() {
        return this.registrationAccessToken;
    }

    public void setAccessToken(String registrationAccessToken) {
        this.registrationAccessToken = registrationAccessToken;
    }

    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public List<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public List<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(List<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public List<String> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<String> contacts) {
        this.contacts = contacts;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getLogoUri() {
        return this.logoUri;
    }

    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    public String getClientUri() {
        return this.clientUri;
    }

    public void setClientUri(String clientUri) {
        this.clientUri = clientUri;
    }

    public AuthenticationMethod getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public void setTokenEndpointAuthMethod(AuthenticationMethod tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    public String getTosUri() {
        return this.tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public SignatureAlgorithm getRequestObjectSigningAlg() {
        return this.requestObjectSigningAlg;
    }

    public void setRequestObjectSigningAlg(SignatureAlgorithm requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public SignatureAlgorithm getUserInfoSignedResponseAlg() {
        return this.userInfoSignedResponseAlg;
    }

    public void setUserInfoSignedResponseAlg(SignatureAlgorithm userInfoSignedResponseAlg) {
        this.userInfoSignedResponseAlg = userInfoSignedResponseAlg;
    }

    public KeyEncryptionAlgorithm getUserInfoEncryptedResponseAlg() {
        return this.userInfoEncryptedResponseAlg;
    }

    public void setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = userInfoEncryptedResponseAlg;
    }

    public BlockEncryptionAlgorithm getUserInfoEncryptedResponseEnc() {
        return this.userInfoEncryptedResponseEnc;
    }

    public void setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm userInfoEncryptedResponseEnc) {
        this.userInfoEncryptedResponseEnc = userInfoEncryptedResponseEnc;
    }

    public SignatureAlgorithm getIdTokenSignedResponseAlg() {
        return this.idTokenSignedResponseAlg;
    }

    public void setIdTokenSignedResponseAlg(SignatureAlgorithm idTokenSignedResponseAlg) {
        this.idTokenSignedResponseAlg = idTokenSignedResponseAlg;
    }

    public KeyEncryptionAlgorithm getIdTokenEncryptedResponseAlg() {
        return this.idTokenEncryptedResponseAlg;
    }

    public void setIdTokenEncryptedResponseAlg(KeyEncryptionAlgorithm idTokenEncryptedResponseAlg) {
        this.idTokenEncryptedResponseAlg = idTokenEncryptedResponseAlg;
    }

    public BlockEncryptionAlgorithm getIdTokenEncryptedResponseEnc() {
        return this.idTokenEncryptedResponseEnc;
    }

    public void setIdTokenEncryptedResponseEnc(BlockEncryptionAlgorithm idTokenEncryptedResponseEnc) {
        this.idTokenEncryptedResponseEnc = idTokenEncryptedResponseEnc;
    }

    public Integer getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(Integer defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    public Boolean getRequireAuthTime() {
        return this.requireAuthTime;
    }

    public void setRequireAuthTime(Boolean requireAuthTime) {
        this.requireAuthTime = requireAuthTime;
    }

    public List<String> getDefaultAcrValues() {
        return this.defaultAcrValues;
    }

    public void setDefaultAcrValues(List<String> defaultAcrValues) {
        this.defaultAcrValues = defaultAcrValues;
    }

    public String getInitiateLoginUri() {
        return this.initiateLoginUri;
    }

    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public List<String> getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public List<String> getRequestUris() {
        return this.requestUris;
    }

    public void setRequestUris(List<String> requestUris) {
        this.requestUris = requestUris;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getFederationId() {
        return this.federationId;
    }

    public void setFederationId(String p_federationId) {
        this.federationId = p_federationId;
    }

    public String getFederationUrl() {
        return this.federationUrl;
    }

    public void setFederationUrl(String p_federationUrl) {
        this.federationUrl = p_federationUrl;
    }

    public String getHttpMethod() {
        return this.m_httpMethod;
    }

    public void setHttpMethod(String p_httpMethod) {
        this.m_httpMethod = p_httpMethod;
    }

    public Map<String, String> getCustomAttributes() {
        return Collections.unmodifiableMap(this.customAttributes);
    }

    public void addCustomAttribute(String p_name, String p_value) {
        if (RegisterRequestParam.isCustomParameterValid((String)p_name)) {
            this.customAttributes.put(p_name, p_value);
        }
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.redirectUris != null && !this.redirectUris.isEmpty()) {
            parameters.put(RegisterRequestParam.REDIRECT_URIS.toString(), StringUtils.toJSONArray(this.redirectUris).toString());
        }
        if (this.responseTypes != null && !this.responseTypes.isEmpty()) {
            parameters.put(RegisterRequestParam.RESPONSE_TYPES.toString(), StringUtils.toJSONArray(this.responseTypes).toString());
        }
        if (this.grantTypes != null && !this.grantTypes.isEmpty()) {
            parameters.put(RegisterRequestParam.GRANT_TYPES.toString(), StringUtils.toJSONArray(this.grantTypes).toString());
        }
        if (this.applicationType != null) {
            parameters.put(RegisterRequestParam.APPLICATION_TYPE.toString(), this.applicationType.toString());
        }
        if (this.contacts != null && !this.contacts.isEmpty()) {
            parameters.put(RegisterRequestParam.CONTACTS.toString(), StringUtils.toJSONArray(this.contacts).toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.clientName)) {
            parameters.put(RegisterRequestParam.CLIENT_NAME.toString(), this.clientName);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.logoUri)) {
            parameters.put(RegisterRequestParam.LOGO_URI.toString(), this.logoUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.clientUri)) {
            parameters.put(RegisterRequestParam.CLIENT_URI.toString(), this.clientUri);
        }
        if (this.tokenEndpointAuthMethod != null) {
            parameters.put(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), this.tokenEndpointAuthMethod.toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.policyUri)) {
            parameters.put(RegisterRequestParam.POLICY_URI.toString(), this.policyUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.tosUri)) {
            parameters.put(RegisterRequestParam.TOS_URI.toString(), this.tosUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.jwksUri)) {
            parameters.put(RegisterRequestParam.JWKS_URI.toString(), this.jwksUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.sectorIdentifierUri)) {
            parameters.put(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), this.sectorIdentifierUri);
        }
        if (this.subjectType != null) {
            parameters.put(RegisterRequestParam.SUBJECT_TYPE.toString(), this.subjectType.toString());
        }
        if (this.requestObjectSigningAlg != null) {
            parameters.put(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), this.requestObjectSigningAlg.getName());
        }
        if (this.userInfoSignedResponseAlg != null) {
            parameters.put(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), this.userInfoSignedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseAlg != null) {
            parameters.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), this.userInfoEncryptedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseEnc != null) {
            parameters.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), this.userInfoEncryptedResponseEnc.getName());
        }
        if (this.idTokenSignedResponseAlg != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), this.idTokenSignedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseAlg != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), this.idTokenEncryptedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseEnc != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), this.idTokenEncryptedResponseEnc.getName());
        }
        if (this.defaultMaxAge != null) {
            parameters.put(RegisterRequestParam.DEFAULT_MAX_AGE.toString(), this.defaultMaxAge.toString());
        }
        if (this.requireAuthTime != null) {
            parameters.put(RegisterRequestParam.REQUIRE_AUTH_TIME.toString(), this.requireAuthTime.toString());
        }
        if (this.defaultAcrValues != null && !this.defaultAcrValues.isEmpty()) {
            parameters.put(RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), StringUtils.toJSONArray(this.defaultAcrValues).toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.initiateLoginUri)) {
            parameters.put(RegisterRequestParam.INITIATE_LOGIN_URI.toString(), this.initiateLoginUri);
        }
        if (this.postLogoutRedirectUris != null && !this.postLogoutRedirectUris.isEmpty()) {
            parameters.put(RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString(), StringUtils.toJSONArray(this.postLogoutRedirectUris).toString());
        }
        if (this.requestUris != null && !this.requestUris.isEmpty()) {
            parameters.put(RegisterRequestParam.REQUEST_URIS.toString(), StringUtils.toJSONArray(this.requestUris).toString());
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            parameters.put(RegisterRequestParam.SCOPES.toString(), StringUtils.toJSONArray(this.scopes).toString());
        }
        if (!org.apache.commons.lang.StringUtils.isBlank((String)this.federationUrl)) {
            parameters.put(RegisterRequestParam.FEDERATION_METADATA_URL.toString(), this.federationUrl);
        }
        if (!org.apache.commons.lang.StringUtils.isBlank((String)this.federationId)) {
            parameters.put(RegisterRequestParam.FEDERATION_METADATA_ID.toString(), this.federationId);
        }
        if (this.customAttributes != null && !this.customAttributes.isEmpty()) {
            for (Map.Entry<String, String> entry : this.customAttributes.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if (!RegisterRequestParam.isCustomParameterValid((String)name) || !org.apache.commons.lang.StringUtils.isNotBlank((String)value)) continue;
                parameters.put(name, value);
            }
        }
        return parameters;
    }

    public static RegisterRequest fromJson(String p_json) throws JSONException {
        JSONObject requestObject = new JSONObject(p_json);
        ArrayList<String> redirectUris = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.REDIRECT_URIS.toString())) {
            JSONArray redirectUrisJsonArray = requestObject.getJSONArray(RegisterRequestParam.REDIRECT_URIS.toString());
            for (int i = 0; i < redirectUrisJsonArray.length(); ++i) {
                String redirectionUri = redirectUrisJsonArray.getString(i);
                redirectUris.add(redirectionUri);
            }
        }
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        if (requestObject.has(RegisterRequestParam.RESPONSE_TYPES.toString())) {
            JSONArray responseTypesJsonArray = requestObject.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString());
            for (int i = 0; i < responseTypesJsonArray.length(); ++i) {
                ResponseType rt = ResponseType.fromString((String)responseTypesJsonArray.getString(i));
                if (rt == null) continue;
                responseTypes.add(rt);
            }
        } else {
            responseTypes.add(ResponseType.CODE);
        }
        ArrayList<GrantType> grantTypes = new ArrayList<GrantType>();
        if (requestObject.has(RegisterRequestParam.GRANT_TYPES.toString())) {
            JSONArray grantTypesJsonArray = requestObject.getJSONArray(RegisterRequestParam.GRANT_TYPES.toString());
            for (int i = 0; i < grantTypesJsonArray.length(); ++i) {
                GrantType gt = GrantType.fromString((String)grantTypesJsonArray.getString(i));
                if (gt == null) continue;
                grantTypes.add(gt);
            }
        } else {
            grantTypes.add(GrantType.AUTHORIZATION_CODE);
        }
        ArrayList<String> contacts = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.CONTACTS.toString())) {
            JSONArray contactsJsonArray = requestObject.getJSONArray(RegisterRequestParam.CONTACTS.toString());
            for (int i = 0; i < contactsJsonArray.length(); ++i) {
                contacts.add(contactsJsonArray.getString(i));
            }
        }
        ArrayList<String> defaultAcrValues = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.DEFAULT_ACR_VALUES.toString())) {
            JSONArray defaultAcrValuesJsonArray = requestObject.getJSONArray(RegisterRequestParam.DEFAULT_ACR_VALUES.toString());
            for (int i = 0; i < defaultAcrValuesJsonArray.length(); ++i) {
                defaultAcrValues.add(defaultAcrValuesJsonArray.getString(i));
            }
        }
        ArrayList<String> postLogoutRedirectUris = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString())) {
            JSONArray postLogoutRedirectUrisJsonArray = requestObject.getJSONArray(RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString());
            for (int i = 0; i < postLogoutRedirectUrisJsonArray.length(); ++i) {
                postLogoutRedirectUris.add(postLogoutRedirectUrisJsonArray.getString(i));
            }
        }
        ArrayList<String> requestUris = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.REQUEST_URIS.toString())) {
            JSONArray requestUrisJsonArray = requestObject.getJSONArray(RegisterRequestParam.REQUEST_URIS.toString());
            for (int i = 0; i < requestUrisJsonArray.length(); ++i) {
                requestUris.add(requestUrisJsonArray.getString(i));
            }
        }
        ArrayList<String> scopes = new ArrayList<String>();
        if (requestObject.has(RegisterRequestParam.SCOPES.toString())) {
            JSONArray scopesJsonArray = requestObject.getJSONArray(RegisterRequestParam.SCOPES.toString());
            for (int i = 0; i < scopesJsonArray.length(); ++i) {
                scopes.add(scopesJsonArray.getString(i));
            }
        }
        RegisterRequest result = new RegisterRequest();
        result.setJsonObject(requestObject);
        result.setFederationUrl(requestObject.optString(RegisterRequestParam.FEDERATION_METADATA_URL.toString()));
        result.setFederationId(requestObject.optString(RegisterRequestParam.FEDERATION_METADATA_ID.toString()));
        result.setRequestUris(requestUris);
        result.setInitiateLoginUri(requestObject.optString(RegisterRequestParam.INITIATE_LOGIN_URI.toString()));
        result.setPostLogoutRedirectUris(postLogoutRedirectUris);
        result.setDefaultAcrValues(defaultAcrValues);
        result.setRequireAuthTime(requestObject.has(RegisterRequestParam.REQUIRE_AUTH_TIME.toString()) && requestObject.getBoolean(RegisterRequestParam.REQUIRE_AUTH_TIME.toString()));
        result.setDefaultMaxAge(requestObject.has(RegisterRequestParam.DEFAULT_MAX_AGE.toString()) ? Integer.valueOf(requestObject.getInt(RegisterRequestParam.DEFAULT_MAX_AGE.toString())) : null);
        result.setIdTokenEncryptedResponseEnc(requestObject.has(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString()) ? BlockEncryptionAlgorithm.fromName((String)requestObject.getString(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString())) : null);
        result.setIdTokenEncryptedResponseAlg(requestObject.has(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString()) ? KeyEncryptionAlgorithm.fromName((String)requestObject.getString(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString())) : null);
        result.setIdTokenSignedResponseAlg(requestObject.has(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()) ? SignatureAlgorithm.fromName((String)requestObject.getString(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString())) : null);
        result.setUserInfoEncryptedResponseEnc(requestObject.has(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString()) ? BlockEncryptionAlgorithm.fromName((String)requestObject.getString(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString())) : null);
        result.setUserInfoEncryptedResponseAlg(requestObject.has(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString()) ? KeyEncryptionAlgorithm.fromName((String)requestObject.getString(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString())) : null);
        result.setUserInfoSignedResponseAlg(requestObject.has(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString()) ? SignatureAlgorithm.fromName((String)requestObject.getString(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString())) : null);
        result.setRedirectUris(redirectUris);
        result.setScopes(scopes);
        result.setResponseTypes(responseTypes);
        result.setGrantTypes(grantTypes);
        result.setApplicationType(requestObject.has(RegisterRequestParam.APPLICATION_TYPE.toString()) ? ApplicationType.fromString((String)requestObject.getString(RegisterRequestParam.APPLICATION_TYPE.toString())) : ApplicationType.WEB);
        result.setContacts(contacts);
        result.setClientName(requestObject.optString(RegisterRequestParam.CLIENT_NAME.toString()));
        result.setLogoUri(requestObject.optString(RegisterRequestParam.LOGO_URI.toString()));
        result.setClientUri(requestObject.optString(RegisterRequestParam.CLIENT_URI.toString()));
        result.setTokenEndpointAuthMethod(requestObject.has(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString()) ? AuthenticationMethod.fromString((String)requestObject.getString(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString())) : AuthenticationMethod.CLIENT_SECRET_BASIC);
        result.setPolicyUri(requestObject.optString(RegisterRequestParam.POLICY_URI.toString()));
        result.setTosUri(requestObject.optString(RegisterRequestParam.TOS_URI.toString()));
        result.setJwksUri(requestObject.optString(RegisterRequestParam.JWKS_URI.toString()));
        result.setSectorIdentifierUri(requestObject.optString(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString()));
        result.setSubjectType(requestObject.has(RegisterRequestParam.SUBJECT_TYPE.toString()) ? SubjectType.fromString((String)requestObject.getString(RegisterRequestParam.SUBJECT_TYPE.toString())) : SubjectType.PUBLIC);
        result.setRequestObjectSigningAlg(requestObject.has(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString()) ? SignatureAlgorithm.fromName((String)requestObject.getString(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString())) : null);
        return result;
    }

    @Override
    public JSONObject getJSONParameters() throws JSONException {
        JSONObject parameters = new JSONObject();
        if (this.redirectUris != null && !this.redirectUris.isEmpty()) {
            parameters.put(RegisterRequestParam.REDIRECT_URIS.toString(), (Object)StringUtils.toJSONArray(this.redirectUris));
        }
        if (this.responseTypes != null && !this.responseTypes.isEmpty()) {
            parameters.put(RegisterRequestParam.RESPONSE_TYPES.toString(), (Object)StringUtils.toJSONArray(this.responseTypes));
        }
        if (this.grantTypes != null && !this.grantTypes.isEmpty()) {
            parameters.put(RegisterRequestParam.GRANT_TYPES.toString(), (Object)StringUtils.toJSONArray(this.grantTypes));
        }
        if (this.applicationType != null) {
            parameters.put(RegisterRequestParam.APPLICATION_TYPE.toString(), (Object)this.applicationType.toString());
        }
        if (this.contacts != null && !this.contacts.isEmpty()) {
            parameters.put(RegisterRequestParam.CONTACTS.toString(), (Object)StringUtils.toJSONArray(this.contacts));
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.clientName)) {
            parameters.put(RegisterRequestParam.CLIENT_NAME.toString(), (Object)this.clientName);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.logoUri)) {
            parameters.put(RegisterRequestParam.LOGO_URI.toString(), (Object)this.logoUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.clientUri)) {
            parameters.put(RegisterRequestParam.CLIENT_URI.toString(), (Object)this.clientUri);
        }
        if (this.tokenEndpointAuthMethod != null) {
            parameters.put(RegisterRequestParam.TOKEN_ENDPOINT_AUTH_METHOD.toString(), (Object)this.tokenEndpointAuthMethod.toString());
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.policyUri)) {
            parameters.put(RegisterRequestParam.POLICY_URI.toString(), (Object)this.policyUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.tosUri)) {
            parameters.put(RegisterRequestParam.TOS_URI.toString(), (Object)this.tosUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.jwksUri)) {
            parameters.put(RegisterRequestParam.JWKS_URI.toString(), (Object)this.jwksUri);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.sectorIdentifierUri)) {
            parameters.put(RegisterRequestParam.SECTOR_IDENTIFIER_URI.toString(), (Object)this.sectorIdentifierUri);
        }
        if (this.subjectType != null) {
            parameters.put(RegisterRequestParam.SUBJECT_TYPE.toString(), (Object)this.subjectType.toString());
        }
        if (this.requestObjectSigningAlg != null) {
            parameters.put(RegisterRequestParam.REQUEST_OBJECT_SIGNING_ALG.toString(), (Object)this.requestObjectSigningAlg.getName());
        }
        if (this.userInfoSignedResponseAlg != null) {
            parameters.put(RegisterRequestParam.USERINFO_SIGNED_RESPONSE_ALG.toString(), (Object)this.userInfoSignedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseAlg != null) {
            parameters.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ALG.toString(), (Object)this.userInfoEncryptedResponseAlg.getName());
        }
        if (this.userInfoEncryptedResponseEnc != null) {
            parameters.put(RegisterRequestParam.USERINFO_ENCRYPTED_RESPONSE_ENC.toString(), (Object)this.userInfoEncryptedResponseEnc.getName());
        }
        if (this.idTokenSignedResponseAlg != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString(), (Object)this.idTokenSignedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseAlg != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ALG.toString(), (Object)this.idTokenEncryptedResponseAlg.getName());
        }
        if (this.idTokenEncryptedResponseEnc != null) {
            parameters.put(RegisterRequestParam.ID_TOKEN_ENCRYPTED_RESPONSE_ENC.toString(), (Object)this.idTokenEncryptedResponseEnc.getName());
        }
        if (this.defaultMaxAge != null) {
            parameters.put(RegisterRequestParam.DEFAULT_MAX_AGE.toString(), (Object)this.defaultMaxAge.toString());
        }
        if (this.requireAuthTime != null) {
            parameters.put(RegisterRequestParam.REQUIRE_AUTH_TIME.toString(), (Object)this.requireAuthTime.toString());
        }
        if (this.defaultAcrValues != null && !this.defaultAcrValues.isEmpty()) {
            parameters.put(RegisterRequestParam.DEFAULT_ACR_VALUES.toString(), (Object)StringUtils.toJSONArray(this.defaultAcrValues));
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)this.initiateLoginUri)) {
            parameters.put(RegisterRequestParam.INITIATE_LOGIN_URI.toString(), (Object)this.initiateLoginUri);
        }
        if (this.postLogoutRedirectUris != null && !this.postLogoutRedirectUris.isEmpty()) {
            parameters.put(RegisterRequestParam.POST_LOGOUT_REDIRECT_URIS.toString(), (Object)StringUtils.toJSONArray(this.postLogoutRedirectUris));
        }
        if (this.requestUris != null && !this.requestUris.isEmpty()) {
            parameters.put(RegisterRequestParam.REQUEST_URIS.toString(), (Object)StringUtils.toJSONArray(this.requestUris));
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            parameters.put(RegisterRequestParam.SCOPES.toString(), (Object)StringUtils.toJSONArray(this.scopes));
        }
        if (!org.apache.commons.lang.StringUtils.isBlank((String)this.federationUrl)) {
            parameters.put(RegisterRequestParam.FEDERATION_METADATA_URL.toString(), (Object)this.federationUrl);
        }
        if (!org.apache.commons.lang.StringUtils.isBlank((String)this.federationId)) {
            parameters.put(RegisterRequestParam.FEDERATION_METADATA_ID.toString(), (Object)this.federationId);
        }
        if (this.customAttributes != null && !this.customAttributes.isEmpty()) {
            for (Map.Entry<String, String> entry : this.customAttributes.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if (!RegisterRequestParam.isCustomParameterValid((String)name) || !org.apache.commons.lang.StringUtils.isNotBlank((String)value)) continue;
                parameters.put(name, (Object)value);
            }
        }
        return parameters;
    }

    public JSONObject getJsonObject() {
        return this.m_jsonObject;
    }

    public void setJsonObject(JSONObject p_jsonObject) {
        this.m_jsonObject = p_jsonObject;
    }

    @Override
    public String getQueryString() {
        String jsonQueryString = null;
        try {
            jsonQueryString = this.getJSONParameters().toString(4).replace("\\/", "/");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonQueryString;
    }
}

