/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.net.URISyntaxException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryRequest;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryResponse;
import org.xdi.oxauth.model.discovery.WebFingerLink;

public class OpenIdConnectDiscoveryClient
extends BaseClient<OpenIdConnectDiscoveryRequest, OpenIdConnectDiscoveryResponse> {
    private static final Logger LOG = Logger.getLogger(OpenIdConnectDiscoveryClient.class);
    private static final String MEDIA_TYPE = "application/json";
    private static final String SCHEMA = "https://";
    private static final String PATH = "/.well-known/webfinger";

    public OpenIdConnectDiscoveryClient(String resource) throws URISyntaxException {
        this.setRequest(new OpenIdConnectDiscoveryRequest(resource));
        this.setUrl(SCHEMA + this.getRequest().getHost() + PATH);
    }

    @Override
    public OpenIdConnectDiscoveryRequest getRequest() {
        if (this.request instanceof OpenIdConnectDiscoveryRequest) {
            return (OpenIdConnectDiscoveryRequest)this.request;
        }
        return null;
    }

    @Override
    public void setRequest(OpenIdConnectDiscoveryRequest request) {
        this.request = request;
    }

    @Override
    public OpenIdConnectDiscoveryResponse getResponse() {
        if (this.response instanceof OpenIdConnectDiscoveryResponse) {
            return (OpenIdConnectDiscoveryResponse)this.response;
        }
        return null;
    }

    @Override
    public void setResponse(OpenIdConnectDiscoveryResponse response) {
        this.response = response;
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public OpenIdConnectDiscoveryResponse exec() {
        this.initClientRequest();
        return this._exec();
    }

    @Deprecated
    public OpenIdConnectDiscoveryResponse exec(ClientExecutor executor) {
        this.clientRequest = new ClientRequest(this.getUrl(), executor);
        return this._exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenIdConnectDiscoveryResponse _exec() {
        OpenIdConnectDiscoveryResponse response = null;
        try {
            response = this._exec2();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return response;
    }

    private OpenIdConnectDiscoveryResponse _exec2() {
        this.clientRequest.accept(MEDIA_TYPE);
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        if (StringUtils.isNotBlank((String)this.getRequest().getResource())) {
            this.clientRequest.queryParameter("resource", (Object)this.getRequest().getResource());
        }
        this.clientRequest.queryParameter("rel", (Object)"http://openid.net/specs/connect/1.0/issuer");
        try {
            ClientResponse clientResponse1 = this.clientRequest.get(String.class);
            int status = clientResponse1.getStatus();
            this.setResponse(new OpenIdConnectDiscoveryResponse(status));
            String entity = (String)clientResponse1.getEntity(String.class);
            this.getResponse().setEntity(entity);
            this.getResponse().setHeaders((MultivaluedMap<String, String>)clientResponse1.getHeaders());
            if (StringUtils.isNotBlank((String)entity)) {
                JSONObject jsonObj = new JSONObject(entity);
                this.getResponse().setSubject(jsonObj.getString("subject"));
                JSONArray linksJsonArray = jsonObj.getJSONArray("links");
                for (int i = 0; i < linksJsonArray.length(); ++i) {
                    WebFingerLink webFingerLink = new WebFingerLink();
                    webFingerLink.setRel(linksJsonArray.getJSONObject(i).getString("rel"));
                    webFingerLink.setHref(linksJsonArray.getJSONObject(i).getString("href"));
                    this.getResponse().getLinks().add(webFingerLink);
                }
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.getResponse();
    }
}

