/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.ArrayList;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.JwkRequest;
import org.xdi.oxauth.client.JwkResponse;
import org.xdi.oxauth.model.crypto.PublicKey;
import org.xdi.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.jwk.JSONWebKey;
import org.xdi.oxauth.model.jwk.KeyType;
import org.xdi.oxauth.model.jwk.Use;

public class JwkClient
extends BaseClient<JwkRequest, JwkResponse> {
    private static final String mediaType = "text/plain";

    public JwkClient(String url) {
        super(url);
    }

    @Override
    public JwkRequest getRequest() {
        if (this.request instanceof JwkRequest) {
            return (JwkRequest)this.request;
        }
        return null;
    }

    @Override
    public void setRequest(JwkRequest request) {
        this.request = request;
    }

    @Override
    public JwkResponse getResponse() {
        if (this.response instanceof JwkResponse) {
            return (JwkResponse)this.response;
        }
        return null;
    }

    @Override
    public void setResponse(JwkResponse response) {
        this.response = response;
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JwkResponse exec() {
        if (this.getRequest() == null) {
            this.setRequest(new JwkRequest());
        }
        this.initClientRequest();
        if (this.getRequest().hasCredentials()) {
            String encodedCredentials = this.getRequest().getEncodedCredentials();
            this.clientRequest.header("Authorization", (Object)("Basic " + encodedCredentials));
        }
        this.clientRequest.accept(mediaType);
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        try {
            JSONObject jsonObj;
            this.clientResponse = this.clientRequest.get(String.class);
            int status = this.clientResponse.getStatus();
            this.setResponse(new JwkResponse(status));
            this.getResponse().setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
            String entity = (String)this.clientResponse.getEntity(String.class);
            this.getResponse().setEntity(entity);
            if (StringUtils.isNotBlank((String)entity) && (jsonObj = new JSONObject(entity)).has("keys")) {
                JSONArray jwks = jsonObj.getJSONArray("keys");
                ArrayList<JSONWebKey> jwkList = new ArrayList<JSONWebKey>();
                for (int i = 0; i < jwks.length(); ++i) {
                    JSONObject jsonKeyValue = jwks.getJSONObject(i);
                    JSONWebKey JSONWebKey2 = new JSONWebKey();
                    if (jsonKeyValue.has("kty")) {
                        JSONWebKey2.setKeyType(KeyType.fromString((String)jsonKeyValue.getString("kty")));
                    }
                    if (jsonKeyValue.has("kid")) {
                        JSONWebKey2.setKeyId(jsonKeyValue.getString("kid"));
                    }
                    if (jsonKeyValue.has("use")) {
                        JSONWebKey2.setUse(Use.fromString((String)jsonKeyValue.getString("use")));
                    }
                    if (jsonKeyValue.has("alg")) {
                        JSONWebKey2.setAlgorithm(jsonKeyValue.getString("alg"));
                    }
                    if (jsonKeyValue.has("n")) {
                        JSONWebKey2.getPublicKey().setModulus(jsonKeyValue.getString("n"));
                    }
                    if (jsonKeyValue.has("e")) {
                        JSONWebKey2.getPublicKey().setExponent(jsonKeyValue.getString("e"));
                    }
                    if (jsonKeyValue.has("crv")) {
                        JSONWebKey2.setCurve(jsonKeyValue.getString("crv"));
                    }
                    if (jsonKeyValue.has("x")) {
                        JSONWebKey2.getPublicKey().setX(jsonKeyValue.getString("x"));
                    }
                    if (jsonKeyValue.has("y")) {
                        JSONWebKey2.getPublicKey().setY(jsonKeyValue.getString("y"));
                    }
                    jwkList.add(JSONWebKey2);
                }
                this.getResponse().setKeys(jwkList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
        return this.getResponse();
    }

    public static RSAPublicKey getRSAPublicKey(String jwkSetUri, String keyId) {
        PublicKey pk;
        RSAPublicKey publicKey = null;
        JwkClient jwkClient = new JwkClient(jwkSetUri);
        JwkResponse jwkResponse = jwkClient.exec();
        if (jwkResponse != null && jwkResponse.getStatus() == 200 && (pk = jwkResponse.getPublicKey(keyId)) instanceof RSAPublicKey) {
            publicKey = (RSAPublicKey)pk;
        }
        return publicKey;
    }

    public static ECDSAPublicKey getECDSAPublicKey(String jwkSetUrl, String keyId) {
        PublicKey pk;
        ECDSAPublicKey publicKey = null;
        JwkClient jwkClient = new JwkClient(jwkSetUrl);
        JwkResponse jwkResponse = jwkClient.exec();
        if (jwkResponse != null && jwkResponse.getStatus() == 200 && (pk = jwkResponse.getPublicKey(keyId)) instanceof ECDSAPublicKey) {
            publicKey = (ECDSAPublicKey)pk;
        }
        return publicKey;
    }
}

