/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.client.BaseRequest;

public class FederationMetadataRequest
extends BaseRequest {
    private String m_federationId;
    private boolean m_signed = true;

    public FederationMetadataRequest() {
        this("");
    }

    public FederationMetadataRequest(String p_federationId) {
        this.m_federationId = p_federationId;
    }

    public boolean isSigned() {
        return this.m_signed;
    }

    public void setSigned(boolean p_signed) {
        this.m_signed = p_signed;
    }

    public String getFederationId() {
        return this.m_federationId;
    }

    public void setFederationId(String p_federationId) {
        this.m_federationId = p_federationId;
    }

    @Override
    public String getQueryString() {
        StringBuilder sb = new StringBuilder();
        try {
            if (StringUtils.isNotBlank((String)this.m_federationId)) {
                sb.append("federation_id=").append(URLEncoder.encode(this.m_federationId, "UTF-8"));
            }
            if (!this.m_signed) {
                sb.append("&signed=").append(URLEncoder.encode(Boolean.valueOf(this.m_signed).toString(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

