/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.model.federation.FederationRequest;

public class FederationDataRequest
extends BaseRequest {
    private String federationId;
    private FederationRequest.Type type;
    private String displayName;
    private String opId;
    private String domain;
    private String redirectUri;
    private String x509pem;
    private String x509url;

    public FederationDataRequest() {
    }

    public FederationDataRequest(FederationRequest.Type p_type) {
        this.type = p_type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String p_displayName) {
        this.displayName = p_displayName;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String p_domain) {
        this.domain = p_domain;
    }

    public String getFederationId() {
        return this.federationId;
    }

    public void setFederationId(String p_federationId) {
        this.federationId = p_federationId;
    }

    public String getOpId() {
        return this.opId;
    }

    public void setOpId(String p_opId) {
        this.opId = p_opId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String p_redirectUri) {
        this.redirectUri = p_redirectUri;
    }

    public FederationRequest.Type getType() {
        return this.type;
    }

    public void setType(FederationRequest.Type p_type) {
        this.type = p_type;
    }

    public String getX509pem() {
        return this.x509pem;
    }

    public void setX509pem(String p_x509pem) {
        this.x509pem = p_x509pem;
    }

    public String getX509url() {
        return this.x509url;
    }

    public void setX509url(String p_x509url) {
        this.x509url = p_x509url;
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.federationId)) {
            map.put("federation_id", this.federationId);
        }
        if (this.type != null) {
            map.put("entity_type", this.type.getValue());
        }
        if (StringUtils.isNotBlank((String)this.displayName)) {
            map.put("display_name", this.displayName);
        }
        if (StringUtils.isNotBlank((String)this.opId)) {
            map.put("op_id", this.opId);
        }
        if (StringUtils.isNotBlank((String)this.domain)) {
            map.put("domain", this.domain);
        }
        if (StringUtils.isNotBlank((String)this.redirectUri)) {
            map.put("redirect_uri", this.redirectUri);
        }
        if (StringUtils.isNotBlank((String)this.x509pem)) {
            map.put("x509_pem", this.x509pem);
        }
        if (StringUtils.isNotBlank((String)this.x509url)) {
            map.put("x509_url", this.x509url);
        }
        return map;
    }

    @Override
    public String getQueryString() {
        StringBuilder sb = new StringBuilder();
        try {
            if (StringUtils.isNotBlank((String)this.federationId)) {
                sb.append("federation_id=").append(URLEncoder.encode(this.federationId, "UTF-8"));
            }
            if (this.type != null) {
                sb.append("&").append("entity_type=").append(URLEncoder.encode(this.type.getValue(), "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.displayName)) {
                sb.append("&").append("display_name=").append(URLEncoder.encode(this.displayName, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.opId)) {
                sb.append("&").append("op_id=").append(URLEncoder.encode(this.opId, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.domain)) {
                sb.append("&").append("domain=").append(URLEncoder.encode(this.domain, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.redirectUri)) {
                sb.append("&").append("redirect_uri=").append(URLEncoder.encode(this.redirectUri, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.x509pem)) {
                sb.append("&").append("x509_pem=").append(URLEncoder.encode(this.x509pem, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.x509url)) {
                sb.append("&").append("x509_url=").append(URLEncoder.encode(this.x509url, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

