/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.common.Display;
import org.xdi.oxauth.model.common.HasParamName;
import org.xdi.oxauth.model.common.Parameters;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;

public class AuthorizeClient
extends BaseClient<AuthorizationRequest, AuthorizationResponse> {
    private static final Logger LOG = Logger.getLogger(AuthorizeClient.class);
    static String NO_REDIRECT_HEADER = "X-Gluu-NoRedirect";

    public AuthorizeClient(String url) {
        super(url);
    }

    @Override
    public AuthorizationRequest getRequest() {
        if (this.request instanceof AuthorizationRequest) {
            return (AuthorizationRequest)this.request;
        }
        return null;
    }

    @Override
    public void setRequest(AuthorizationRequest request) {
        this.request = request;
    }

    @Override
    public AuthorizationResponse getResponse() {
        if (this.response instanceof AuthorizationResponse) {
            return (AuthorizationResponse)this.response;
        }
        return null;
    }

    @Override
    public void setResponse(AuthorizationResponse response) {
        this.response = response;
    }

    @Override
    public String getHttpMethod() {
        if (this.request.getAuthorizationMethod() == null || this.request.getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
            return "POST";
        }
        return "GET";
    }

    public AuthorizationResponse execAuthorizationCodeGrant(String clientId, List<String> scopes, String redirectUri, String nonce, String state, String req, String reqUri, Display display, List<Prompt> prompt) {
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.CODE);
        this.setRequest(new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce));
        this.getRequest().setRedirectUri(redirectUri);
        this.getRequest().setState(state);
        this.getRequest().setRequest(req);
        this.getRequest().setRedirectUri(reqUri);
        this.getRequest().setDisplay(display);
        this.getRequest().getPrompts().addAll(prompt);
        return this.exec();
    }

    public AuthorizationResponse execImplicitGrant(String clientId, List<String> scopes, String redirectUri, String nonce, String state, String req, String reqUri, Display display, List<Prompt> prompt) {
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        this.setRequest(new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce));
        this.getRequest().setRedirectUri(redirectUri);
        this.getRequest().setState(state);
        this.getRequest().setRequest(req);
        this.getRequest().setRedirectUri(reqUri);
        this.getRequest().setDisplay(display);
        this.getRequest().getPrompts().addAll(prompt);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse exec() {
        AuthorizationResponse response = null;
        try {
            this.initClientRequest();
            response = this.exec_();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return response;
    }

    @Deprecated
    public AuthorizationResponse exec(ClientExecutor clientExecutor) {
        AuthorizationResponse response = null;
        try {
            this.clientRequest = new ClientRequest(this.getUrl(), clientExecutor);
            response = this.exec_();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    private AuthorizationResponse exec_() throws Exception {
        this.clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        if (this.getRequest().isUseNoRedirectHeader()) {
            this.clientRequest.header(NO_REDIRECT_HEADER, (Object)"true");
        }
        String responseTypesAsString = this.getRequest().getResponseTypesAsString();
        String scopesAsString = this.getRequest().getScopesAsString();
        String promptsAsString = this.getRequest().getPromptsAsString();
        String uiLocalesAsString = this.getRequest().getUiLocalesAsString();
        String claimLocalesAsString = this.getRequest().getClaimsLocalesAsString();
        String acrValuesAsString = this.getRequest().getAcrValuesAsString();
        String claimsAsString = this.getRequest().getClaimsAsString();
        this.addReqParam("response_type", responseTypesAsString);
        this.addReqParam("client_id", this.getRequest().getClientId());
        this.addReqParam("scope", scopesAsString);
        this.addReqParam("redirect_uri", this.getRequest().getRedirectUri());
        this.addReqParam("state", this.getRequest().getState());
        this.addReqParam("nonce", this.getRequest().getNonce());
        this.addReqParam("display", (HasParamName)this.getRequest().getDisplay());
        this.addReqParam("prompt", promptsAsString);
        if (this.getRequest().getMaxAge() != null) {
            this.addReqParam("max_age", this.getRequest().getMaxAge().toString());
        }
        this.addReqParam("ui_locales", uiLocalesAsString);
        this.addReqParam("claims_locales", claimLocalesAsString);
        this.addReqParam("id_token_hint", this.getRequest().getIdTokenHint());
        this.addReqParam("login_hint", this.getRequest().getLoginHint());
        this.addReqParam("acr_values", acrValuesAsString);
        this.addReqParam("claims", claimsAsString);
        this.addReqParam("registration", this.getRequest().getRegistration());
        this.addReqParam("request", this.getRequest().getRequest());
        this.addReqParam("request_uri", this.getRequest().getRequestUri());
        this.addReqParam("access_token", this.getRequest().getAccessToken());
        if (this.getRequest().isRequestSessionId()) {
            this.addReqParam(Parameters.REQUEST_SESSION_ID.getParamName(), Boolean.toString(this.getRequest().isRequestSessionId()));
        }
        this.addReqParam(Parameters.SESSION_ID.getParamName(), this.getRequest().getSessionId());
        for (String key : this.request.getCustomParameters().keySet()) {
            this.addReqParam(key, this.request.getCustomParameters().get(key));
        }
        if (this.request.getAuthorizationMethod() != AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER && this.request.hasCredentials()) {
            this.clientRequest.header("Authorization", (Object)("Basic " + this.request.getEncodedCredentials()));
        }
        this.clientResponse = this.request.getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER ? this.clientRequest.post(String.class) : this.clientRequest.get(String.class);
        this.setResponse(new AuthorizationResponse((ClientResponse<String>)this.clientResponse));
        return this.getResponse();
    }
}

