/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.uma;

import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.uma.ResourceSetRegistrationService;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.wrapper.UmaClient;
import org.xdi.oxauth.model.uma.MetadataConfiguration;
import org.xdi.oxauth.model.uma.ResourceSet;
import org.xdi.oxauth.model.uma.ResourceSetStatus;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.VersionedResourceSet;
import org.xdi.oxauth.model.uma.wrapper.Token;

public class RegisterResourceSetFlowHttpTest
extends BaseTest {
    protected MetadataConfiguration metadataConfiguration;
    protected Token m_pat;
    protected String resourceSetId;
    protected String resourceVersion;

    public RegisterResourceSetFlowHttpTest() {
    }

    public RegisterResourceSetFlowHttpTest(MetadataConfiguration metadataConfiguration) {
        this.metadataConfiguration = metadataConfiguration;
    }

    @BeforeClass
    @Parameters(value={"umaMetaDataUrl", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri"})
    public void init(String umaMetaDataUrl, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri) throws Exception {
        if (this.metadataConfiguration == null) {
            this.metadataConfiguration = UmaClientFactory.instance().createMetaDataConfigurationService(umaMetaDataUrl).getMetadataConfiguration();
            UmaTestUtil.assert_((MetadataConfiguration)this.metadataConfiguration);
        }
        this.m_pat = UmaClient.requestPat((String)this.authorizationEndpoint, (String)this.tokenEndpoint, (String)umaUserId, (String)umaUserSecret, (String)umaPatClientId, (String)umaPatClientSecret, (String)umaRedirectUri);
        UmaTestUtil.assert_((Token)this.m_pat);
    }

    @Test
    public void testRegisterResourceSet() throws Exception {
        this.showTitle("testRegisterResourceSet");
        ResourceSetRegistrationService resourceSetRegistrationService = UmaClientFactory.instance().createResourceSetRegistrationService(this.metadataConfiguration);
        ResourceSetStatus resourceSetStatus = null;
        try {
            ResourceSet resourceSet = new ResourceSet();
            resourceSet.setName("Photo Album");
            resourceSet.setIconUri("http://www.example.com/icons/flower.png");
            resourceSet.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all"));
            String id = String.valueOf(System.currentTimeMillis());
            resourceSetStatus = resourceSetRegistrationService.addResourceSet("Bearer " + this.m_pat.getAccessToken(), id, resourceSet);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        UmaTestUtil.assert_((ResourceSetStatus)resourceSetStatus);
        this.resourceSetId = resourceSetStatus.getId();
        this.resourceVersion = resourceSetStatus.getRev();
        Assert.assertEquals((String)this.resourceVersion, (String)"1", (String)"Resource set description revision is not 1");
    }

    @Test(dependsOnMethods={"testRegisterResourceSet"})
    public void testModifyResourceSet() throws Exception {
        this.showTitle("testModifyResourceSet");
        ResourceSetRegistrationService resourceSetRegistrationService = UmaClientFactory.instance().createResourceSetRegistrationService(this.metadataConfiguration);
        ResourceSetStatus resourceSetStatus = null;
        try {
            ResourceSet resourceSet = new ResourceSet();
            resourceSet.setName("Photo Album 2");
            resourceSet.setIconUri("http://www.example.com/icons/flower.png");
            resourceSet.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all"));
            resourceSetStatus = resourceSetRegistrationService.updateResourceSet("Bearer " + this.m_pat.getAccessToken(), this.resourceVersion, this.resourceSetId, resourceSet);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        Assert.assertNotNull((Object)resourceSetStatus, (String)"Resource set status is null");
        this.resourceSetId = resourceSetStatus.getId();
        this.resourceVersion = resourceSetStatus.getRev();
        Assert.assertNotNull((Object)this.resourceSetId, (String)"Resource set description id is null");
        Assert.assertNotNull((Object)this.resourceVersion, (String)"Resource set description revision is null");
        Assert.assertEquals((String)this.resourceVersion, (String)"2", (String)"Resource set description revision is not 2");
    }

    @Test(dependsOnMethods={"testModifyResourceSet"})
    public void testModifyNotExistingResourceSet() throws Exception {
        this.showTitle("testModifyNotExistingResourceSet");
        ResourceSetRegistrationService resourceSetRegistrationService = UmaClientFactory.instance().createResourceSetRegistrationService(this.metadataConfiguration);
        ResourceSetStatus resourceSetStatus = null;
        try {
            ResourceSet resourceSet = new ResourceSet();
            resourceSet.setName("Photo Album 3");
            resourceSet.setIconUri("http://www.example.com/icons/flower.png");
            resourceSet.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all"));
            resourceSetStatus = resourceSetRegistrationService.updateResourceSet("Bearer " + this.m_pat.getAccessToken(), this.resourceVersion, this.resourceSetId + "1", resourceSet);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            Assert.assertEquals((int)ex.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode(), (String)"Unexpected response status");
        }
        Assert.assertNull(resourceSetStatus, (String)"Resource set status is not null");
    }

    @Test(dependsOnMethods={"testModifyResourceSet"})
    public void testModifyResourceSetWithInvalidPat() throws Exception {
        this.showTitle("testModifyResourceSetWithInvalidPat");
        ResourceSetRegistrationService resourceSetRegistrationService = UmaClientFactory.instance().createResourceSetRegistrationService(this.metadataConfiguration);
        ResourceSetStatus resourceSetStatus = null;
        try {
            ResourceSet resourceSet = new ResourceSet();
            resourceSet.setName("Photo Album 4");
            resourceSet.setIconUri("http://www.example.com/icons/flower.png");
            resourceSet.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all"));
            resourceSetStatus = resourceSetRegistrationService.updateResourceSet("Bearer " + this.m_pat.getAccessToken() + "_invalid", this.resourceVersion, this.resourceSetId + "_invalid", resourceSet);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            Assert.assertEquals((int)ex.getResponse().getStatus(), (int)Response.Status.UNAUTHORIZED.getStatusCode(), (String)"Unexpected response status");
        }
        Assert.assertNull(resourceSetStatus, (String)"Resource set status is not null");
    }

    @Test(dependsOnMethods={"testModifyResourceSet"})
    public void testGetOneResourceSet() throws Exception {
        this.showTitle("testGetResourceSets");
        ResourceSetRegistrationService resourceSetRegistrationService = UmaClientFactory.instance().createResourceSetRegistrationService(this.metadataConfiguration);
        VersionedResourceSet resourceSets = null;
        try {
            resourceSets = resourceSetRegistrationService.getResourceSet("Bearer " + this.m_pat.getAccessToken(), this.resourceSetId);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        Assert.assertNotNull((Object)resourceSets, (String)"Resource set descriptions is null");
    }

    @Test(dependsOnMethods={"testGetOneResourceSet"})
    public void testGetResourceSets() throws Exception {
        this.showTitle("testGetResourceSets");
        ResourceSetRegistrationService resourceSetRegistrationService = UmaClientFactory.instance().createResourceSetRegistrationService(this.metadataConfiguration);
        List resourceSets = null;
        try {
            resourceSets = resourceSetRegistrationService.getResourceSetList("Bearer " + this.m_pat.getAccessToken(), "");
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        Assert.assertNotNull((Object)resourceSets, (String)"Resource set descriptions is null");
        Assert.assertTrue((boolean)resourceSets.contains(this.resourceSetId), (String)"Resource set descriptions list doesn't contain added resource set description");
    }

    @Test(dependsOnMethods={"testGetResourceSets"})
    public void testDeleteResourceSet() throws Exception {
        this.showTitle("testDeleteResourceSet");
        ResourceSetRegistrationService resourceSetRegistrationService = UmaClientFactory.instance().createResourceSetRegistrationService(this.metadataConfiguration);
        boolean deleted = false;
        try {
            resourceSetRegistrationService.deleteResourceSet("Bearer " + this.m_pat.getAccessToken(), this.resourceVersion, this.resourceSetId);
            deleted = true;
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        Assert.assertTrue((boolean)deleted, (String)"Failed to delete resource set description");
    }
}

