/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.uma;

import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.uma.RequesterPermissionTokenService;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.wrapper.UmaClient;
import org.xdi.oxauth.model.uma.MetadataConfiguration;
import org.xdi.oxauth.model.uma.RequesterPermissionTokenResponse;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;

public class ObtainRptTokenFlowHttpTest
extends BaseTest {
    protected MetadataConfiguration metadataConfiguration;
    protected Token m_aat;
    protected String rptToken;

    public ObtainRptTokenFlowHttpTest() {
    }

    public ObtainRptTokenFlowHttpTest(MetadataConfiguration metadataConfiguration) {
        this.metadataConfiguration = metadataConfiguration;
    }

    @BeforeClass
    @Parameters(value={"umaMetaDataUrl", "umaUserId", "umaUserSecret", "umaAatClientId", "umaAatClientSecret", "umaRedirectUri"})
    public void init(String umaMetaDataUrl, String umaUserId, String umaUserSecret, String umaAatClientId, String umaAatClientSecret, String umaRedirectUri) throws Exception {
        if (this.metadataConfiguration == null) {
            this.metadataConfiguration = UmaClientFactory.instance().createMetaDataConfigurationService(umaMetaDataUrl).getMetadataConfiguration();
            UmaTestUtil.assert_((MetadataConfiguration)this.metadataConfiguration);
        }
        this.m_aat = UmaClient.requestAat((String)this.authorizationEndpoint, (String)this.tokenEndpoint, (String)umaUserId, (String)umaUserSecret, (String)umaAatClientId, (String)umaAatClientSecret, (String)umaRedirectUri);
        UmaTestUtil.assert_((Token)this.m_aat);
    }

    @Test
    @Parameters(value={"umaAmHost"})
    public void testObtainRptTokenFlow(String umaAmHost) throws Exception {
        this.showTitle("testObtainRptTokenFlow");
        RequesterPermissionTokenService requesterPermissionTokenService = UmaClientFactory.instance().createRequesterPermissionTokenService(this.metadataConfiguration);
        RequesterPermissionTokenResponse requesterPermissionTokenResponse = null;
        try {
            requesterPermissionTokenResponse = requesterPermissionTokenService.getRequesterPermissionToken("Bearer " + this.m_aat.getAccessToken(), umaAmHost);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        UmaTestUtil.assert_((RequesterPermissionTokenResponse)requesterPermissionTokenResponse);
        this.rptToken = requesterPermissionTokenResponse.getToken();
    }

    @Test
    @Parameters(value={"umaAmHost"})
    public void testObtainRptTokenFlowWithInvalidAat(String umaAmHost) throws Exception {
        this.showTitle("testObtainRptTokenFlowWithInvalidAat");
        RequesterPermissionTokenService requesterPermissionTokenService = UmaClientFactory.instance().createRequesterPermissionTokenService(this.metadataConfiguration);
        RequesterPermissionTokenResponse requesterPermissionTokenResponse = null;
        try {
            requesterPermissionTokenResponse = requesterPermissionTokenService.getRequesterPermissionToken("Bearer " + this.m_aat.getAccessToken() + "_invalid", umaAmHost);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            Assert.assertEquals((int)ex.getResponse().getStatus(), (int)Response.Status.UNAUTHORIZED.getStatusCode(), (String)"Unexpected response status");
        }
        Assert.assertNull((Object)requesterPermissionTokenResponse, (String)"Requester permission token response is not null");
    }
}

