/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.uma;

import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.uma.wrapper.UmaClient;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;

public class ObtainPatTokenFlowHttpTest
extends BaseTest {
    protected Token m_pat;

    @Test
    @Parameters(value={"umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri"})
    public void testObtainPatTokenFlow(String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri) throws Exception {
        this.showTitle("testObtainPatTokenFlow");
        this.m_pat = UmaClient.requestPat((String)this.authorizationEndpoint, (String)this.tokenEndpoint, (String)umaUserId, (String)umaUserSecret, (String)umaPatClientId, (String)umaPatClientSecret, (String)umaRedirectUri);
        UmaTestUtil.assert_((Token)this.m_pat);
    }

    @Test(dependsOnMethods={"testObtainPatTokenFlow"})
    @Parameters(value={"umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri"})
    public void testObtainPatTokenUsingRefreshTokenFlow(String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri) throws Exception {
        this.showTitle("testObtainPatTokenUsingRefreshTokenFlow");
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        TokenResponse response1 = tokenClient1.execRefreshToken(this.m_pat.getScope(), this.m_pat.getRefreshToken(), umaPatClientId, umaPatClientSecret);
        ObtainPatTokenFlowHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
    }
}

