/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoRequest;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.client.model.authorize.Claim;
import org.xdi.oxauth.client.model.authorize.ClaimValue;
import org.xdi.oxauth.client.model.authorize.JwtAuthorizationRequest;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.encryption.BlockEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.encryption.KeyEncryptionAlgorithm;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class UserInfoRestWebServiceHttpTest
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "clientId", "redirectUri"})
    @Test
    public void requestUserInfoImplicitFlow(String userId, String userSecret, String clientId, String redirectUri) throws Exception {
        this.showTitle("requestUserInfoImplicitFlow");
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        responseTypes.add(ResponseType.ID_TOKEN);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("openid");
        scopes.add("profile");
        scopes.add("address");
        scopes.add("email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(request);
        AuthorizationResponse response1 = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The id token must be null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response2 = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getClaim("sub"));
        Assert.assertNotNull((Object)response2.getClaim("name"));
        Assert.assertNotNull((Object)response2.getClaim("given_name"));
        Assert.assertNotNull((Object)response2.getClaim("family_name"));
        Assert.assertNotNull((Object)response2.getClaim("email"));
        Assert.assertNotNull((Object)response2.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response2.getClaim("locale"));
    }

    @Parameters(value={"userId", "userSecret", "clientId", "clientSecret"})
    @Test
    public void requestUserInfoPasswordFlow(String userId, String userSecret, String clientId, String clientSecret) throws Exception {
        this.showTitle("requestUserInfoPasswordFlow");
        String username = userId;
        String password = userSecret;
        String scope = "openid profile address email";
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        TokenResponse response1 = tokenClient.execResourceOwnerPasswordCredentialsGrant(username, password, scope, clientId, clientSecret);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        String accessToken = response1.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response2 = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getClaim("sub"));
        Assert.assertNotNull((Object)response2.getClaim("name"));
        Assert.assertNotNull((Object)response2.getClaim("given_name"));
        Assert.assertNotNull((Object)response2.getClaim("family_name"));
        Assert.assertNotNull((Object)response2.getClaim("email"));
        Assert.assertNotNull((Object)response2.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response2.getClaim("locale"));
    }

    @Test
    public void requestUserInfoInvalidRequest() throws Exception {
        this.showTitle("requestUserInfoInvalidRequest");
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response = userInfoClient.execUserInfo(null);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getStatus()));
        Assert.assertNotNull((Object)response.getErrorType(), (String)"Unexpected result: errorType not found");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"Unexpected result: errorDescription not found");
    }

    @Test
    public void requestUserInfoInvalidToken() throws Exception {
        this.showTitle("requestUserInfoInvalidToken");
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse response = userInfoClient.execUserInfo("INVALID_ACCESS_TOKEN");
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getStatus()));
        Assert.assertNotNull((Object)response.getErrorType(), (String)"Unexpected result: errorType not found");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"Unexpected result: errorDescription not found");
    }

    @Parameters(value={"userId", "userSecret", "clientId", "redirectUri"})
    @Test
    public void requestUserInfoInsufficientScope(String userId, String userSecret, String clientId, String redirectUri) throws Exception {
        this.showTitle("requestUserInfoInsufficientScope");
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        responseTypes.add(ResponseType.ID_TOKEN);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("picture");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.getPrompts().add(Prompt.NONE);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(request);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String idToken = authorizationResponse.getIdToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(idToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)403, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getErrorType(), (String)"Unexpected result: errorType not found");
        Assert.assertNotNull((Object)userInfoResponse.getErrorDescription(), (String)"Unexpected result: errorDescription not found");
    }

    @Parameters(value={"userId", "userSecret", "clientId", "clientSecret", "redirectUri"})
    @Test
    public void requestUserInfoAdditionalClaims(String userId, String userSecret, String clientId, String clientSecret, String redirectUri) throws Exception {
        this.showTitle("requestUserInfoAdditionalClaims");
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("openid");
        scopes.add("profile");
        scopes.add("address");
        scopes.add("email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(authorizationRequest, SignatureAlgorithm.HS256, clientSecret);
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("invalid", ClaimValue.createEssential((boolean)false)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("iname", ClaimValue.createNull()));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("gluuStatus", ClaimValue.createEssential((boolean)true)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("gluuWhitePagesListed", ClaimValue.createEssential((boolean)true)));
        jwtAuthorizationRequest.addUserInfoClaim(new Claim("o", ClaimValue.createEssential((boolean)true)));
        String authJwt = jwtAuthorizationRequest.getEncodedJwt();
        authorizationRequest.setRequest(authJwt);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse response1 = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope must be null");
        String accessToken = response1.getAccessToken();
        UserInfoRequest userInfoRequest1 = new UserInfoRequest(accessToken);
        userInfoRequest1.setAuthorizationMethod(AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD);
        UserInfoClient userInfoClient1 = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient1.setRequest(userInfoRequest1);
        UserInfoResponse response2 = userInfoClient1.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient1);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getClaim("sub"));
        Assert.assertNotNull((Object)response2.getClaim("name"));
        Assert.assertNotNull((Object)response2.getClaim("given_name"));
        Assert.assertNotNull((Object)response2.getClaim("family_name"));
        Assert.assertNotNull((Object)response2.getClaim("email"));
        Assert.assertNotNull((Object)response2.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response2.getClaim("locale"));
        Assert.assertNotNull((Object)response2.getClaim("iname"), (String)"Unexpected result: iname not found");
        Assert.assertNotNull((Object)response2.getClaim("gluuStatus"), (String)"Unexpected result: gluuStatus not found");
        Assert.assertNotNull((Object)response2.getClaim("gluuWhitePagesListed"), (String)"Unexpected result: gluuWhitePagesListed not found");
        Assert.assertNotNull((Object)response2.getClaim("o"), (String)"Unexpected result: organization not found");
        UserInfoRequest userInfoRequest2 = new UserInfoRequest(accessToken);
        userInfoRequest2.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
        UserInfoClient userInfoClient2 = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient2.setRequest(userInfoRequest2);
        UserInfoResponse response3 = userInfoClient2.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient2);
        Assert.assertEquals((int)response3.getStatus(), (int)200, (String)("Unexpected response code: " + response3.getStatus()));
        Assert.assertNotNull((Object)response3.getClaim("sub"));
        Assert.assertNotNull((Object)response3.getClaim("name"));
        Assert.assertNotNull((Object)response3.getClaim("given_name"));
        Assert.assertNotNull((Object)response3.getClaim("family_name"));
        Assert.assertNotNull((Object)response3.getClaim("email"));
        Assert.assertNotNull((Object)response3.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response3.getClaim("locale"));
        UserInfoRequest userInfoRequest3 = new UserInfoRequest(accessToken);
        userInfoRequest3.setAuthorizationMethod(AuthorizationMethod.URL_QUERY_PARAMETER);
        UserInfoClient userInfoClient3 = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient3.setRequest(userInfoRequest3);
        UserInfoResponse response4 = userInfoClient3.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient3);
        Assert.assertEquals((int)response4.getStatus(), (int)200, (String)("Unexpected response code: " + response4.getStatus()));
        Assert.assertNotNull((Object)response4.getClaim("sub"));
        Assert.assertNotNull((Object)response4.getClaim("name"));
        Assert.assertNotNull((Object)response4.getClaim("given_name"));
        Assert.assertNotNull((Object)response4.getClaim("family_name"));
        Assert.assertNotNull((Object)response4.getClaim("email"));
        Assert.assertNotNull((Object)response4.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)response4.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void requestUserInfoHS256(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("requestUserInfoHS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.HS256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void requestUserInfoHS384(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("requestUserInfoHS384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.HS384);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void requestUserInfoHS512(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("requestUserInfoHS512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.HS512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void requestUserInfoRS256(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("requestUserInfoRS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.RS256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setJwksUri(this.jwksUri);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void requestUserInfoRS384(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("requestUserInfoRS384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.RS384);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setJwksUri(this.jwksUri);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void requestUserInfoRS512(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("requestUserInfoRS512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.RS512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setJwksUri(this.jwksUri);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void requestUserInfoES256(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("requestUserInfoES256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.ES256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setJwksUri(this.jwksUri);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void requestUserInfoES384(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("requestUserInfoES384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.ES384);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setJwksUri(this.jwksUri);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void requestUserInfoES512(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("requestUserInfoES512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.ES512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setJwksUri(this.jwksUri);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS256_modulus", "RS256_privateExponent"})
    @Test
    public void requestUserInfoAlgRSAOAEPEncA256GCM(String redirectUris, String redirectUri, String userId, String userSecret, String jwksUri, String modulus, String privateExponent) throws Exception {
        this.showTitle("requestUserInfoAlgRSAOAEPEncA256GCM");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA_OAEP);
        registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A256GCM);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        RSAPrivateKey rsaPrivateKey = new RSAPrivateKey(modulus, privateExponent);
        UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken);
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setRsaPrivateKey(rsaPrivateKey);
        userInfoClient.setRequest(userInfoRequest);
        UserInfoResponse userInfoResponse = userInfoClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS256_modulus", "RS256_privateExponent"})
    @Test
    public void requestUserInfoAlgRSA15EncA128CBCPLUSHS256(String redirectUris, String redirectUri, String userId, String userSecret, String jwksUri, String modulus, String privateExponent) throws Exception {
        this.showTitle("requestUserInfoAlgRSA15EncA128CBCPLUSHS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA1_5);
        registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A128CBC_PLUS_HS256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        RSAPrivateKey rsaPrivateKey = new RSAPrivateKey(modulus, privateExponent);
        UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken);
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setRsaPrivateKey(rsaPrivateKey);
        userInfoClient.setRequest(userInfoRequest);
        UserInfoResponse userInfoResponse = userInfoClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret", "clientJwksUri", "RS256_modulus", "RS256_privateExponent"})
    @Test
    public void requestUserInfoAlgRSA15EncA256CBCPLUSHS512(String redirectUris, String redirectUri, String userId, String userSecret, String jwksUri, String modulus, String privateExponent) throws Exception {
        this.showTitle("requestUserInfoAlgRSA15EncA256CBCPLUSHS512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setJwksUri(jwksUri);
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.RSA1_5);
        registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A256CBC_PLUS_HS512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        RSAPrivateKey rsaPrivateKey = new RSAPrivateKey(modulus, privateExponent);
        UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken);
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setRsaPrivateKey(rsaPrivateKey);
        userInfoClient.setRequest(userInfoRequest);
        UserInfoResponse userInfoResponse = userInfoClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void requestUserInfoAlgA128KWEncA128GCM(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("requestUserInfoAlgA128KWEncA128GCM");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.A128KW);
        registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A128GCM);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken);
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        userInfoClient.setRequest(userInfoRequest);
        UserInfoResponse userInfoResponse = userInfoClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }

    @Parameters(value={"redirectUris", "redirectUri", "userId", "userSecret"})
    @Test
    public void requestUserInfoAlgA256KWEncA256GCM(String redirectUris, String redirectUri, String userId, String userSecret) throws Exception {
        this.showTitle("requestUserInfoAlgA256KWEncA256GCM");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoEncryptedResponseAlg(KeyEncryptionAlgorithm.A256KW);
        registerRequest.setUserInfoEncryptedResponseEnc(BlockEncryptionAlgorithm.A256GCM);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken);
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        userInfoClient.setRequest(userInfoRequest);
        UserInfoResponse userInfoResponse = userInfoClient.exec();
        UserInfoRestWebServiceHttpTest.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }
}

