/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.EndSessionClient;
import org.xdi.oxauth.client.EndSessionRequest;
import org.xdi.oxauth.client.EndSessionResponse;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class EndSessionRestWebServiceHttpTest
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris", "postLogoutRedirectUri"})
    @Test
    public void requestEndSession(String userId, String userSecret, String redirectUri, String redirectUris, String postLogoutRedirectUri) throws Exception {
        this.showTitle("requestEndSession");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN));
        registerRequest.setPostLogoutRedirectUris(Arrays.asList(postLogoutRedirectUri));
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse response = registerClient.exec();
        EndSessionRestWebServiceHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        String clientId = response.getClientId();
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        responseTypes.add(ResponseType.ID_TOKEN);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("openid");
        scopes.add("profile");
        scopes.add("address");
        scopes.add("email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(request);
        AuthorizationResponse response1 = authorizeClient.exec();
        EndSessionRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope must be null");
        String idToken = response1.getIdToken();
        EndSessionClient endSessionClient = new EndSessionClient(this.endSessionEndpoint);
        EndSessionResponse endSessionResponse = endSessionClient.execEndSession(idToken, postLogoutRedirectUri);
        EndSessionRequest endSessionRequest = new EndSessionRequest(idToken, postLogoutRedirectUri);
        EndSessionRestWebServiceHttpTest.showClient((BaseClient)endSessionClient);
        Assert.assertEquals((int)endSessionResponse.getStatus(), (int)302, (String)("Unexpected response code: " + endSessionResponse.getStatus()));
        Assert.assertNotNull((Object)endSessionResponse.getLocation(), (String)"The location is null");
    }

    @Test
    public void requestEndSessionFail1() throws Exception {
        this.showTitle("requestEndSessionFail1");
        EndSessionClient endSessionClient = new EndSessionClient(this.endSessionEndpoint);
        EndSessionResponse response = endSessionClient.execEndSession(null, null);
        EndSessionRestWebServiceHttpTest.showClient((BaseClient)endSessionClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code. Entity: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
    }

    @Parameters(value={"postLogoutRedirectUri"})
    @Test
    public void requestEndSessionFail2(String postLogoutRedirectUri) throws Exception {
        this.showTitle("requestEndSessionFail2");
        String state = "xyz";
        EndSessionClient endSessionClient = new EndSessionClient(this.endSessionEndpoint);
        EndSessionResponse response = endSessionClient.execEndSession("INVALID_ACCESS_TOKEN", postLogoutRedirectUri);
        EndSessionRestWebServiceHttpTest.showClient((BaseClient)endSessionClient);
        Assert.assertEquals((int)response.getStatus(), (int)401, (String)("Unexpected response code. Entity: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
    }
}

