/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.ArrayList;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.ClientInfoClient;
import org.xdi.oxauth.client.ClientInfoResponse;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;

public class ClientInfoRestWebServiceHttpTest
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "clientId", "redirectUri"})
    @Test
    public void requestClientInfoImplicitFlow(String userId, String userSecret, String clientId, String redirectUri) throws Exception {
        this.showTitle("requestClientInfoImplicitFlow");
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        responseTypes.add(ResponseType.ID_TOKEN);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("clientinfo");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        ClientInfoRestWebServiceHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)authorizationResponse.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The id token must be null");
        String accessToken = authorizationResponse.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse clientInfoResponse = clientInfoClient.execClientInfo(accessToken);
        ClientInfoRestWebServiceHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)clientInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + clientInfoResponse.getStatus()));
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("inum"), (String)"Unexpected result: inum not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("oxAuthAppType"), (String)"Unexpected result: oxAuthAppType not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("oxAuthIdTokenSignedResponseAlg"), (String)"Unexpected result: oxAuthIdTokenSignedResponseAlg not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("oxAuthRedirectURI"), (String)"Unexpected result: oxAuthRedirectURI not found");
        Assert.assertNotNull((Object)clientInfoResponse.getClaim("oxAuthScope"), (String)"Unexpected result: oxAuthScope not found");
    }

    @Parameters(value={"userId", "userSecret", "clientId", "clientSecret"})
    @Test
    public void requestClientInfoPasswordFlow(String userId, String userSecret, String clientId, String clientSecret) throws Exception {
        this.showTitle("requestClientInfoPasswordFlow");
        String username = userId;
        String password = userSecret;
        String scope = "clientinfo";
        TokenClient tokenClient = new TokenClient(this.tokenEndpoint);
        TokenResponse response1 = tokenClient.execResourceOwnerPasswordCredentialsGrant(username, password, scope, clientId, clientSecret);
        ClientInfoRestWebServiceHttpTest.showClient((BaseClient)tokenClient);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
        String accessToken = response1.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse response2 = clientInfoClient.execClientInfo(accessToken);
        ClientInfoRestWebServiceHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)response2.getClaim("inum"), (String)"Unexpected result: inum not found");
        Assert.assertNotNull((Object)response2.getClaim("oxAuthAppType"), (String)"Unexpected result: oxAuthAppType not found");
        Assert.assertNotNull((Object)response2.getClaim("oxAuthIdTokenSignedResponseAlg"), (String)"Unexpected result: oxAuthIdTokenSignedResponseAlg not found");
        Assert.assertNotNull((Object)response2.getClaim("oxAuthRedirectURI"), (String)"Unexpected result: oxAuthRedirectURI not found");
        Assert.assertNotNull((Object)response2.getClaim("oxAuthScope"), (String)"Unexpected result: oxAuthScope not found");
    }

    @Test
    public void requestClientInfoInvalidRequest() throws Exception {
        this.showTitle("requestClientInfoInvalidRequest");
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse response = clientInfoClient.execClientInfo(null);
        ClientInfoRestWebServiceHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getStatus()));
        Assert.assertNotNull((Object)response.getErrorType(), (String)"Unexpected result: errorType not found");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"Unexpected result: errorDescription not found");
    }

    @Test
    public void requestClientInfoInvalidToken() throws Exception {
        this.showTitle("requestClientInfoInvalidToken");
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        ClientInfoResponse response = clientInfoClient.execClientInfo("INVALID-TOKEN");
        ClientInfoRestWebServiceHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code: " + response.getStatus()));
        Assert.assertNotNull((Object)response.getErrorType(), (String)"Unexpected result: errorType not found");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"Unexpected result: errorDescription not found");
    }
}

