/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class CanRequestAndUseSignedUserInfoResponse
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUri", "redirectUris"})
    @Test
    public void canRequestAndUseSignedUserInfoResponse(String userId, String userSecret, String redirectUri, String redirectUris) throws Exception {
        this.showTitle("OC5:FeatureTest-Can Request and Use Signed UserInfo Response");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setUserInfoSignedResponseAlg(SignatureAlgorithm.HS256);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        CanRequestAndUseSignedUserInfoResponse.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken(), (String)"The accessToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getTokenType(), (String)"The tokenType is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setSharedKey(clientSecret);
        UserInfoResponse userInfoResponse = userInfoClient.execUserInfo(accessToken);
        CanRequestAndUseSignedUserInfoResponse.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("picture"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("region"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("street_address"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("country"));
    }
}

