/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.ValidateTokenRequest;
import org.xdi.oxauth.client.ValidateTokenResponse;
import org.xdi.oxauth.model.token.ValidateTokenErrorResponseType;

public class ValidateTokenClient
extends BaseClient<ValidateTokenRequest, ValidateTokenResponse> {
    private static final String mediaType = "application/json";

    public ValidateTokenClient(String url) {
        super(url);
    }

    @Override
    public ValidateTokenRequest getRequest() {
        if (this.request instanceof ValidateTokenRequest) {
            return (ValidateTokenRequest)this.request;
        }
        return null;
    }

    @Override
    public void setRequest(ValidateTokenRequest request) {
        this.request = request;
    }

    @Override
    public ValidateTokenResponse getResponse() {
        if (this.response instanceof ValidateTokenResponse) {
            return (ValidateTokenResponse)this.response;
        }
        return null;
    }

    @Override
    public void setResponse(ValidateTokenResponse response) {
        this.response = response;
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public ValidateTokenResponse execValidateToken(String accessToken) {
        this.setRequest(new ValidateTokenRequest());
        this.getRequest().setAccessToken(accessToken);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidateTokenResponse exec() {
        this.initClientRequest();
        this.clientRequest.accept(mediaType);
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        if (StringUtils.isNotBlank((String)this.getRequest().getAccessToken())) {
            this.clientRequest.queryParameter("access_token", (Object)this.getRequest().getAccessToken());
        }
        try {
            this.clientResponse = this.clientRequest.get(String.class);
            int status = this.clientResponse.getStatus();
            this.setResponse(new ValidateTokenResponse(status));
            this.getResponse().setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
            String entity = (String)this.clientResponse.getEntity(String.class);
            this.getResponse().setEntity(entity);
            if (entity != null && !entity.isEmpty()) {
                JSONObject jsonObj = new JSONObject(entity);
                if (jsonObj.has("valid")) {
                    this.getResponse().setValid(jsonObj.getBoolean("valid"));
                }
                if (jsonObj.has("expires_in")) {
                    this.getResponse().setExpiresIn(jsonObj.getInt("expires_in"));
                }
                if (jsonObj.has("error")) {
                    this.getResponse().setErrorType(ValidateTokenErrorResponseType.fromString((String)jsonObj.getString("error")));
                }
                if (jsonObj.has("error_description")) {
                    this.getResponse().setErrorDescription(jsonObj.getString("error_description"));
                }
                if (jsonObj.has("error_uri")) {
                    this.getResponse().setErrorUri(jsonObj.getString("error_uri"));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
        return this.getResponse();
    }
}

