/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.ClientResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.token.ClientAssertionType;

public class TokenClient
extends BaseClient<TokenRequest, TokenResponse> {
    private static final Logger LOG = Logger.getLogger(TokenClient.class);

    public TokenClient(String url) {
        super(url);
    }

    @Override
    public TokenRequest getRequest() {
        if (this.request instanceof TokenRequest) {
            return (TokenRequest)this.request;
        }
        return null;
    }

    @Override
    public void setRequest(TokenRequest request) {
        this.request = request;
    }

    @Override
    public TokenResponse getResponse() {
        if (this.response instanceof TokenResponse) {
            return (TokenResponse)this.response;
        }
        return null;
    }

    @Override
    public void setResponse(TokenResponse response) {
        this.response = response;
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public TokenResponse execAuthorizationCode(String code, String redirectUri, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.AUTHORIZATION_CODE));
        this.getRequest().setCode(code);
        this.getRequest().setRedirectUri(redirectUri);
        this.getRequest().setAuthUsername(clientId);
        this.getRequest().setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execResourceOwnerPasswordCredentialsGrant(String username, String password, String scope, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS));
        this.getRequest().setUsername(username);
        this.getRequest().setPassword(password);
        this.getRequest().setScope(scope);
        this.getRequest().setAuthUsername(clientId);
        this.getRequest().setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execClientCredentialsGrant(String scope, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.CLIENT_CREDENTIALS));
        this.getRequest().setScope(scope);
        this.getRequest().setAuthUsername(clientId);
        this.getRequest().setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execExtensionGrant(String grantTypeUri, String assertion, String clientId, String clientSecret) {
        GrantType grantType = GrantType.fromString((String)grantTypeUri);
        this.setRequest(new TokenRequest(grantType));
        this.getRequest().setAssertion(assertion);
        this.getRequest().setAuthUsername(clientId);
        this.getRequest().setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execRefreshToken(String scope, String refreshToken, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.REFRESH_TOKEN));
        this.getRequest().setScope(scope);
        this.getRequest().setRefreshToken(refreshToken);
        this.getRequest().setAuthUsername(clientId);
        this.getRequest().setAuthPassword(clientSecret);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenResponse exec() {
        this.initClientRequest();
        if (this.request.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_BASIC && this.request.hasCredentials()) {
            this.clientRequest.header("Authorization", (Object)("Basic " + this.request.getEncodedCredentials()));
        }
        this.clientRequest.header("Content-Type", (Object)this.request.getContentType());
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        if (this.getRequest().getGrantType() != null) {
            this.clientRequest.formParameter("grant_type", (Object)this.getRequest().getGrantType());
        }
        if (StringUtils.isNotBlank((String)this.getRequest().getCode())) {
            this.clientRequest.formParameter("code", (Object)this.getRequest().getCode());
        }
        if (StringUtils.isNotBlank((String)this.getRequest().getRedirectUri())) {
            this.clientRequest.formParameter("redirect_uri", (Object)this.getRequest().getRedirectUri());
        }
        if (StringUtils.isNotBlank((String)this.getRequest().getUsername())) {
            this.clientRequest.formParameter("username", (Object)this.getRequest().getUsername());
        }
        if (StringUtils.isNotBlank((String)this.getRequest().getPassword())) {
            this.clientRequest.formParameter("password", (Object)this.getRequest().getPassword());
        }
        if (StringUtils.isNotBlank((String)this.getRequest().getScope())) {
            this.clientRequest.formParameter("scope", (Object)this.getRequest().getScope());
        }
        if (StringUtils.isNotBlank((String)this.getRequest().getAssertion())) {
            this.clientRequest.formParameter("assertion", (Object)this.getRequest().getAssertion());
        }
        if (StringUtils.isNotBlank((String)this.getRequest().getRefreshToken())) {
            this.clientRequest.formParameter("refresh_token", (Object)this.getRequest().getRefreshToken());
        }
        if (StringUtils.isNotBlank((String)this.getRequest().getOxAuthExchangeToken())) {
            this.clientRequest.formParameter("oxauth_exchange_token", (Object)this.getRequest().getOxAuthExchangeToken());
        }
        if (this.getRequest().getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_POST) {
            if (this.getRequest().getAuthUsername() != null && !this.getRequest().getAuthUsername().isEmpty()) {
                this.clientRequest.formParameter("client_id", (Object)this.getRequest().getAuthUsername());
            }
            if (this.getRequest().getAuthPassword() != null && !this.getRequest().getAuthPassword().isEmpty()) {
                this.clientRequest.formParameter("client_secret", (Object)this.getRequest().getAuthPassword());
            }
        } else if (this.getRequest().getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_JWT || this.getRequest().getAuthenticationMethod() == AuthenticationMethod.PRIVATE_KEY_JWT) {
            this.clientRequest.formParameter("client_assertion_type", (Object)ClientAssertionType.JWT_BEARER);
            this.clientRequest.formParameter("client_assertion", (Object)this.getRequest().getClientAssertion());
        }
        for (String key : this.getRequest().getCustomParameters().keySet()) {
            this.clientRequest.formParameter(key, (Object)this.getRequest().getCustomParameters().get(key));
        }
        try {
            this.clientResponse = this.clientRequest.post(String.class);
            TokenResponse tokenResponse = new TokenResponse((ClientResponse<String>)this.clientResponse);
            tokenResponse.injectDataFromJson();
            this.setResponse(tokenResponse);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return this.getResponse();
    }
}

