/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.OpenIdConfigurationRequest;
import org.xdi.oxauth.client.OpenIdConfigurationResponse;
import org.xdi.oxauth.model.util.Util;

public class OpenIdConfigurationClient
extends BaseClient<OpenIdConfigurationRequest, OpenIdConfigurationResponse> {
    private static final Logger LOG = Logger.getLogger(OpenIdConfigurationClient.class);
    private static final String mediaType = "text/plain";

    public OpenIdConfigurationClient(String url) {
        super(url);
    }

    @Override
    public OpenIdConfigurationRequest getRequest() {
        if (this.request instanceof OpenIdConfigurationRequest) {
            return (OpenIdConfigurationRequest)this.request;
        }
        return null;
    }

    @Override
    public void setRequest(OpenIdConfigurationRequest request) {
        this.request = request;
    }

    @Override
    public OpenIdConfigurationResponse getResponse() {
        if (this.response instanceof OpenIdConfigurationResponse) {
            return (OpenIdConfigurationResponse)this.response;
        }
        return null;
    }

    @Override
    public void setResponse(OpenIdConfigurationResponse response) {
        this.response = response;
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public OpenIdConfigurationResponse execOpenIdConfiguration() {
        this.initClientRequest();
        return this._execOpenIdConfiguration();
    }

    @Deprecated
    public OpenIdConfigurationResponse execOpenIdConfiguration(ClientExecutor executor) {
        this.clientRequest = new ClientRequest(this.getUrl(), executor);
        return this._execOpenIdConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenIdConfigurationResponse _execOpenIdConfiguration() {
        this.setRequest(new OpenIdConfigurationRequest());
        this.clientRequest.accept(mediaType);
        this.clientRequest.setHttpMethod(this.getHttpMethod());
        try {
            this.clientResponse = this.clientRequest.get(String.class);
            int status = this.clientResponse.getStatus();
            this.setResponse(new OpenIdConfigurationResponse(status));
            String entity = (String)this.clientResponse.getEntity(String.class);
            this.getResponse().setEntity(entity);
            this.getResponse().setHeaders((MultivaluedMap<String, String>)this.clientResponse.getHeaders());
            if (StringUtils.isNotBlank((String)entity)) {
                JSONObject jsonObj = new JSONObject(entity);
                if (jsonObj.has("issuer")) {
                    this.getResponse().setIssuer(jsonObj.getString("issuer"));
                }
                if (jsonObj.has("authorization_endpoint")) {
                    this.getResponse().setAuthorizationEndpoint(jsonObj.getString("authorization_endpoint"));
                }
                if (jsonObj.has("token_endpoint")) {
                    this.getResponse().setTokenEndpoint(jsonObj.getString("token_endpoint"));
                }
                if (jsonObj.has("userinfo_endpoint")) {
                    this.getResponse().setUserInfoEndpoint(jsonObj.getString("userinfo_endpoint"));
                }
                if (jsonObj.has("clientinfo_endpoint")) {
                    this.getResponse().setClientInfoEndpoint(jsonObj.getString("clientinfo_endpoint"));
                }
                if (jsonObj.has("check_session_iframe")) {
                    this.getResponse().setCheckSessionIFrame(jsonObj.getString("check_session_iframe"));
                }
                if (jsonObj.has("end_session_endpoint")) {
                    this.getResponse().setEndSessionEndpoint(jsonObj.getString("end_session_endpoint"));
                }
                if (jsonObj.has("jwks_uri")) {
                    this.getResponse().setJwksUri(jsonObj.getString("jwks_uri"));
                }
                if (jsonObj.has("registration_endpoint")) {
                    this.getResponse().setRegistrationEndpoint(jsonObj.getString("registration_endpoint"));
                }
                if (jsonObj.has("validate_token_endpoint")) {
                    this.getResponse().setValidateTokenEndpoint(jsonObj.getString("validate_token_endpoint"));
                }
                if (jsonObj.has("federation_metadata_endpoint")) {
                    this.getResponse().setFederationMetadataEndpoint(jsonObj.getString("federation_metadata_endpoint"));
                }
                if (jsonObj.has("federation_endpoint")) {
                    this.getResponse().setFederationEndpoint(jsonObj.getString("federation_endpoint"));
                }
                if (jsonObj.has("id_generation_endpoint")) {
                    this.getResponse().setIdGenerationEndpoint(jsonObj.getString("id_generation_endpoint"));
                }
                if (jsonObj.has("introspection_endpoint")) {
                    this.getResponse().setIntrospectionEndpoint(jsonObj.getString("introspection_endpoint"));
                }
                if (jsonObj.has("scope_to_claims_mapping")) {
                    this.getResponse().setScopeToClaimsMapping(OpenIdConfigurationResponse.parseScopeToClaimsMapping(jsonObj.getJSONArray("scope_to_claims_mapping")));
                }
                Util.addToListIfHas(this.getResponse().getScopesSupported(), (JSONObject)jsonObj, (String)"scopes_supported");
                Util.addToListIfHas(this.getResponse().getResponseTypesSupported(), (JSONObject)jsonObj, (String)"response_types_supported");
                Util.addToListIfHas(this.getResponse().getGrantTypesSupported(), (JSONObject)jsonObj, (String)"grant_types_supported");
                Util.addToListIfHas(this.getResponse().getAcrValuesSupported(), (JSONObject)jsonObj, (String)"acr_values_supported");
                Util.addToListIfHas(this.getResponse().getAmrValuesSupported(), (JSONObject)jsonObj, (String)"amr_values_supported");
                Util.addToListIfHas(this.getResponse().getSubjectTypesSupported(), (JSONObject)jsonObj, (String)"subject_types_supported");
                Util.addToListIfHas(this.getResponse().getUserInfoSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_signing_alg_values_supported");
                Util.addToListIfHas(this.getResponse().getUserInfoEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_encryption_alg_values_supported");
                Util.addToListIfHas(this.getResponse().getUserInfoEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"userinfo_encryption_enc_values_supported");
                Util.addToListIfHas(this.getResponse().getIdTokenSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"id_token_signing_alg_values_supported");
                Util.addToListIfHas(this.getResponse().getIdTokenEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"id_token_encryption_alg_values_supported");
                Util.addToListIfHas(this.getResponse().getIdTokenEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"id_token_encryption_enc_values_supported");
                Util.addToListIfHas(this.getResponse().getRequestObjectSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"request_object_signing_alg_values_supported");
                Util.addToListIfHas(this.getResponse().getRequestObjectEncryptionAlgValuesSupported(), (JSONObject)jsonObj, (String)"request_object_encryption_alg_values_supported");
                Util.addToListIfHas(this.getResponse().getRequestObjectEncryptionEncValuesSupported(), (JSONObject)jsonObj, (String)"request_object_encryption_enc_values_supported");
                Util.addToListIfHas(this.getResponse().getTokenEndpointAuthMethodsSupported(), (JSONObject)jsonObj, (String)"token_endpoint_auth_methods_supported");
                Util.addToListIfHas(this.getResponse().getTokenEndpointAuthSigningAlgValuesSupported(), (JSONObject)jsonObj, (String)"token_endpoint_auth_signing_alg_values_supported");
                Util.addToListIfHas(this.getResponse().getDisplayValuesSupported(), (JSONObject)jsonObj, (String)"display_values_supported");
                Util.addToListIfHas(this.getResponse().getClaimTypesSupported(), (JSONObject)jsonObj, (String)"claim_types_supported");
                Util.addToListIfHas(this.getResponse().getClaimsSupported(), (JSONObject)jsonObj, (String)"claims_supported");
                if (jsonObj.has("service_documentation")) {
                    this.getResponse().setServiceDocumentation(jsonObj.getString("service_documentation"));
                }
                Util.addToListIfHas(this.getResponse().getClaimsLocalesSupported(), (JSONObject)jsonObj, (String)"claims_locales_supported");
                Util.addToListIfHas(this.getResponse().getUiLocalesSupported(), (JSONObject)jsonObj, (String)"ui_locales_supported");
                if (jsonObj.has("claims_parameter_supported")) {
                    this.getResponse().setClaimsParameterSupported(jsonObj.getBoolean("claims_parameter_supported"));
                }
                if (jsonObj.has("request_parameter_supported")) {
                    this.getResponse().setRequestParameterSupported(jsonObj.getBoolean("request_parameter_supported"));
                }
                if (jsonObj.has("request_uri_parameter_supported")) {
                    this.getResponse().setRequestUriParameterSupported(jsonObj.getBoolean("request_uri_parameter_supported"));
                }
                if (jsonObj.has("require_request_uri_registration")) {
                    this.getResponse().setRequireRequestUriRegistration(jsonObj.getBoolean("require_request_uri_registration"));
                }
                if (jsonObj.has("op_policy_uri")) {
                    this.getResponse().setOpPolicyUri(jsonObj.getString("op_policy_uri"));
                }
                if (jsonObj.has("op_tos_uri")) {
                    this.getResponse().setOpTosUri(jsonObj.getString("op_tos_uri"));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return this.getResponse();
    }
}

