/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.xdi.oxauth.client.BaseRequest;
import org.xdi.oxauth.model.common.Parameters;

public class EndSessionRequest
extends BaseRequest {
    private String idTokenHint;
    private String postLogoutRedirectUri;
    private String sessionId;

    public EndSessionRequest(String idTokenHint, String postLogoutRedirectUri) {
        this.idTokenHint = idTokenHint;
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setAccessToken(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String p_sessionId) {
        this.sessionId = p_sessionId;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            if (StringUtils.isNotBlank((String)this.idTokenHint)) {
                queryStringBuilder.append("id_token_hint").append("=").append(this.idTokenHint);
            }
            if (StringUtils.isNotBlank((String)this.postLogoutRedirectUri)) {
                queryStringBuilder.append("&").append("post_logout_redirect_uri").append("=").append(URLEncoder.encode(this.postLogoutRedirectUri, "UTF-8"));
            }
            if (StringUtils.isNotBlank((String)this.sessionId)) {
                queryStringBuilder.append(Parameters.SESSION_ID.nameToAppend()).append(this.sessionId);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return queryStringBuilder.toString();
    }
}

