/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.uma;

import java.util.Arrays;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.uma.ResourceSetPermissionRegistrationService;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.model.uma.MetadataConfiguration;
import org.xdi.oxauth.model.uma.ResourceSetPermissionRequest;
import org.xdi.oxauth.model.uma.ResourceSetPermissionTicket;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.ws.rs.uma.RegisterResourceSetFlowHttpTest;

public class RegisterResourceSetPermissionFlowHttpTest
extends BaseTest {
    protected MetadataConfiguration metadataConfiguration;
    protected RegisterResourceSetFlowHttpTest umaRegisterResourceSetFlowHttpTest;
    protected String ticketForFullAccess;

    public RegisterResourceSetPermissionFlowHttpTest() {
    }

    public RegisterResourceSetPermissionFlowHttpTest(MetadataConfiguration metadataConfiguration) {
        this.metadataConfiguration = metadataConfiguration;
    }

    @BeforeClass
    @Parameters(value={"umaMetaDataUrl", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri"})
    public void init(String umaMetaDataUrl, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri) throws Exception {
        if (this.metadataConfiguration == null) {
            this.metadataConfiguration = UmaClientFactory.instance().createMetaDataConfigurationService(umaMetaDataUrl).getMetadataConfiguration();
            UmaTestUtil.assert_((MetadataConfiguration)this.metadataConfiguration);
        }
        this.umaRegisterResourceSetFlowHttpTest = new RegisterResourceSetFlowHttpTest(this.metadataConfiguration);
        this.umaRegisterResourceSetFlowHttpTest.setAuthorizationEndpoint(this.authorizationEndpoint);
        this.umaRegisterResourceSetFlowHttpTest.setTokenEndpoint(this.tokenEndpoint);
        this.umaRegisterResourceSetFlowHttpTest.init(umaMetaDataUrl, umaUserId, umaUserSecret, umaPatClientId, umaPatClientSecret, umaRedirectUri);
        this.umaRegisterResourceSetFlowHttpTest.testRegisterResourceSet();
    }

    @AfterClass
    public void clean() throws Exception {
        this.umaRegisterResourceSetFlowHttpTest.testDeleteResourceSet();
    }

    @Test
    @Parameters(value={"umaAmHost"})
    public void testRegisterResourceSetPermission(String umaAmHost) throws Exception {
        this.showTitle("testRegisterResourceSetPermission");
        ResourceSetPermissionRegistrationService resourceSetPermissionRegistrationService = UmaClientFactory.instance().createResourceSetPermissionRegistrationService(this.metadataConfiguration);
        ResourceSetPermissionRequest resourceSetPermissionRequest = new ResourceSetPermissionRequest();
        resourceSetPermissionRequest.setResourceSetId(this.umaRegisterResourceSetFlowHttpTest.resourceSetId);
        resourceSetPermissionRequest.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view"));
        ResourceSetPermissionTicket t = null;
        try {
            t = resourceSetPermissionRegistrationService.registerResourceSetPermission("Bearer " + this.umaRegisterResourceSetFlowHttpTest.m_pat.getAccessToken(), umaAmHost, "photoz.example.com", resourceSetPermissionRequest);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        UmaTestUtil.assert_((ResourceSetPermissionTicket)t);
        this.ticketForFullAccess = t.getTicket();
    }

    @Test
    @Parameters(value={"umaAmHost"})
    public void testRegisterResourceSetPermissionForInvalidResource(String umaAmHost) throws Exception {
        this.showTitle("testRegisterResourceSetPermissionForInvalidResource");
        ResourceSetPermissionRegistrationService resourceSetPermissionRegistrationService = UmaClientFactory.instance().createResourceSetPermissionRegistrationService(this.metadataConfiguration);
        ResourceSetPermissionRequest resourceSetPermissionRequest = new ResourceSetPermissionRequest();
        resourceSetPermissionRequest.setResourceSetId(this.umaRegisterResourceSetFlowHttpTest.resourceSetId + "1");
        resourceSetPermissionRequest.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all"));
        ResourceSetPermissionTicket resourceSetPermissionTiket = null;
        try {
            resourceSetPermissionTiket = resourceSetPermissionRegistrationService.registerResourceSetPermission("Bearer " + this.umaRegisterResourceSetFlowHttpTest.m_pat.getAccessToken(), umaAmHost, "photoz.example.com", resourceSetPermissionRequest);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            Assert.assertEquals((int)ex.getResponse().getStatus(), (int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Unexpected response status");
        }
        Assert.assertNull((Object)resourceSetPermissionTiket, (String)"Resource set permission is not null");
    }
}

