/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.uma;

import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.uma.wrapper.UmaClient;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;

public class ObtainAatTokenFlowHttpTest
extends BaseTest {
    protected Token m_aat;

    @Test
    @Parameters(value={"umaUserId", "umaUserSecret", "umaAatClientId", "umaAatClientSecret", "umaRedirectUri"})
    public void testObtainAatTokenFlow(String umaUserId, String umaUserSecret, String umaAatClientId, String umaAatClientSecret, String umaRedirectUri) throws Exception {
        this.showTitle("testObtainAatTokenFlow");
        this.m_aat = UmaClient.requestAat((String)this.authorizationEndpoint, (String)this.tokenEndpoint, (String)umaUserId, (String)umaUserSecret, (String)umaAatClientId, (String)umaAatClientSecret, (String)umaRedirectUri);
        UmaTestUtil.assert_((Token)this.m_aat);
    }

    @Test(dependsOnMethods={"testObtainAatTokenFlow"})
    @Parameters(value={"umaUserId", "umaUserSecret", "umaAatClientId", "umaAatClientSecret", "umaRedirectUri"})
    public void testObtainAatTokenUsingRefreshTokenFlow(String umaUserId, String umaUserSecret, String umaAatClientId, String umaAatClientSecret, String umaRedirectUri) throws Exception {
        this.showTitle("testObtainAatTokenUsingRefreshTokenFlow");
        TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
        TokenResponse response1 = tokenClient1.execRefreshToken(this.m_aat.getScope(), this.m_aat.getRefreshToken(), umaAatClientId, umaAatClientSecret);
        ObtainAatTokenFlowHttpTest.showClient((BaseClient)tokenClient1);
        Assert.assertEquals((int)response1.getStatus(), (int)200, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getRefreshToken(), (String)"The refresh token is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope is null");
    }
}

