/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs.uma;

import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.uma.AuthorizationRequestService;
import org.xdi.oxauth.client.uma.RptStatusService;
import org.xdi.oxauth.client.uma.UmaClientFactory;
import org.xdi.oxauth.client.uma.wrapper.UmaClient;
import org.xdi.oxauth.model.uma.MetadataConfiguration;
import org.xdi.oxauth.model.uma.RptAuthorizationRequest;
import org.xdi.oxauth.model.uma.RptStatusRequest;
import org.xdi.oxauth.model.uma.RptStatusResponse;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.ws.rs.uma.ObtainRptTokenFlowHttpTest;
import org.xdi.oxauth.ws.rs.uma.RegisterResourceSetFlowHttpTest;
import org.xdi.oxauth.ws.rs.uma.RegisterResourceSetPermissionFlowHttpTest;

public class AccessProtectedResourceFlowHttpTest
extends BaseTest {
    protected MetadataConfiguration metadataConfiguration;
    protected ObtainRptTokenFlowHttpTest umaObtainRptTokenFlowHttpTest;
    protected RegisterResourceSetFlowHttpTest umaRegisterResourceSetFlowHttpTest;
    protected RegisterResourceSetPermissionFlowHttpTest umaRegisterResourceSetPermissionFlowHttpTest;
    protected RptStatusService rptStatusService;
    protected AuthorizationRequestService rptPermissionAuthorizationService;
    protected Token m_aat;
    protected Token m_pat;

    @BeforeClass
    @Parameters(value={"umaMetaDataUrl"})
    public void init(String umaMetaDataUrl) throws Exception {
        this.metadataConfiguration = UmaClientFactory.instance().createMetaDataConfigurationService(umaMetaDataUrl).getMetadataConfiguration();
        UmaTestUtil.assert_((MetadataConfiguration)this.metadataConfiguration);
        this.umaObtainRptTokenFlowHttpTest = new ObtainRptTokenFlowHttpTest(this.metadataConfiguration);
        this.umaRegisterResourceSetFlowHttpTest = new RegisterResourceSetFlowHttpTest(this.metadataConfiguration);
        this.umaRegisterResourceSetPermissionFlowHttpTest = new RegisterResourceSetPermissionFlowHttpTest(this.metadataConfiguration);
        this.rptStatusService = UmaClientFactory.instance().createRptStatusService(this.metadataConfiguration);
        this.rptPermissionAuthorizationService = UmaClientFactory.instance().createAuthorizationRequestService(this.metadataConfiguration);
    }

    @Test
    @Parameters(value={"umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri"})
    public void testHostObtainPat(String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri) throws Exception {
        this.showTitle("testHostObtainPat");
        this.m_pat = UmaClient.requestPat((String)this.authorizationEndpoint, (String)this.tokenEndpoint, (String)umaUserId, (String)umaUserSecret, (String)umaPatClientId, (String)umaPatClientSecret, (String)umaRedirectUri);
        UmaTestUtil.assert_((Token)this.m_pat);
        this.umaRegisterResourceSetFlowHttpTest.m_pat = this.m_pat;
        this.umaRegisterResourceSetPermissionFlowHttpTest.umaRegisterResourceSetFlowHttpTest = this.umaRegisterResourceSetFlowHttpTest;
    }

    @Test(dependsOnMethods={"testHostObtainPat"})
    public void testHostRegisterResourceSet() throws Exception {
        this.showTitle("testHostRegisterResourceSet");
        this.umaRegisterResourceSetFlowHttpTest.testRegisterResourceSet();
    }

    @Test(dependsOnMethods={"testHostRegisterResourceSet"})
    @Parameters(value={"umaUserId", "umaUserSecret", "umaAatClientId", "umaAatClientSecret", "umaRedirectUri"})
    public void testRequesterObtainAat(String umaUserId, String umaUserSecret, String umaAatClientId, String umaAatClientSecret, String umaRedirectUri) throws Exception {
        this.showTitle("testRequesterObtainAat");
        this.m_aat = UmaClient.requestAat((String)this.authorizationEndpoint, (String)this.tokenEndpoint, (String)umaUserId, (String)umaUserSecret, (String)umaAatClientId, (String)umaAatClientSecret, (String)umaRedirectUri);
        UmaTestUtil.assert_((Token)this.m_aat);
        this.umaObtainRptTokenFlowHttpTest.m_aat = this.m_aat;
    }

    @Test(dependsOnMethods={"testRequesterObtainAat"})
    @Parameters(value={"umaAmHost"})
    public void testRequesterObtainsRpt(String umaAmHost) throws Exception {
        this.showTitle("testRequesterObtainsRpt");
        this.umaObtainRptTokenFlowHttpTest.testObtainRptTokenFlow(umaAmHost);
    }

    @Test(dependsOnMethods={"testRequesterObtainsRpt"})
    public void testRequesterAccessProtectedResourceWithNotEnoughPermissionsRpt() throws Exception {
        this.showTitle("testRequesterAccessProtectedResourceWithNotEnoughPermissionsRpt");
    }

    @Test(dependsOnMethods={"testRequesterAccessProtectedResourceWithNotEnoughPermissionsRpt"})
    @Parameters(value={"umaAmHost"})
    public void testHostDetermineRptStatus1(String umaAmHost) throws Exception {
        this.showTitle("testHostDetermineRptStatus1");
        String resourceSetId = this.umaRegisterResourceSetFlowHttpTest.resourceSetId;
        RptStatusResponse tokenStatusResponse = null;
        try {
            RptStatusRequest tokenStatusRequest = new RptStatusRequest(this.umaObtainRptTokenFlowHttpTest.rptToken, resourceSetId);
            tokenStatusResponse = this.rptStatusService.requestRptStatus("Bearer " + this.m_pat.getAccessToken(), tokenStatusRequest);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        Assert.assertNotNull((Object)tokenStatusResponse, (String)"Token response status is not invalid");
        Assert.assertTrue((boolean)tokenStatusResponse.getActive(), (String)"Token response status is not active");
        Assert.assertTrue((tokenStatusResponse.getPermissions() == null || tokenStatusResponse.getPermissions().isEmpty() ? 1 : 0) != 0);
    }

    @Test(dependsOnMethods={"testHostDetermineRptStatus1"})
    @Parameters(value={"umaAmHost"})
    public void testHostRegisterPermissions(String umaAmHost) throws Exception {
        this.showTitle("testHostRegisterPermissions");
        this.umaRegisterResourceSetPermissionFlowHttpTest.testRegisterResourceSetPermission(umaAmHost);
    }

    @Test(dependsOnMethods={"testHostRegisterPermissions"})
    public void testHostReturnTicketToRequester() throws Exception {
        this.showTitle("testHostReturnTicketToRequester");
    }

    @Test(dependsOnMethods={"testHostReturnTicketToRequester"})
    @Parameters(value={"umaAmHost"})
    public void testRequesterAsksForAuthorization(String umaAmHost) throws Exception {
        this.showTitle("testRequesterAsksForAuthorization");
        ClientResponse authorizationResponse = null;
        try {
            RptAuthorizationRequest rptAuthorizationRequest = new RptAuthorizationRequest(this.umaObtainRptTokenFlowHttpTest.rptToken, this.umaRegisterResourceSetPermissionFlowHttpTest.ticketForFullAccess);
            authorizationResponse = this.rptPermissionAuthorizationService.requestRptPermissionAuthorization("Bearer " + this.m_aat.getAccessToken(), umaAmHost, rptAuthorizationRequest);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        UmaTestUtil.assertAuthorizationRequest((ClientResponse)authorizationResponse);
    }

    @Test(dependsOnMethods={"testRequesterAsksForAuthorization"})
    public void testRequesterAccessProtectedResourceWithEnoughPermissionsRpt() throws Exception {
        this.showTitle("testRequesterAccessProtectedResourceWithEonughPermissionsRpt");
    }

    @Test(dependsOnMethods={"testRequesterAccessProtectedResourceWithEnoughPermissionsRpt"})
    @Parameters(value={"umaAmHost"})
    public void testHostDetermineRptStatus2(String umaAmHost) throws Exception {
        this.showTitle("testHostDetermineRptStatus2");
        String resourceSetId = this.umaRegisterResourceSetFlowHttpTest.resourceSetId;
        RptStatusResponse tokenStatusResponse = null;
        try {
            RptStatusRequest tokenStatusRequest = new RptStatusRequest(this.umaObtainRptTokenFlowHttpTest.rptToken, resourceSetId);
            tokenStatusResponse = this.rptStatusService.requestRptStatus("Bearer " + this.m_pat.getAccessToken(), tokenStatusRequest);
        }
        catch (ClientResponseFailure ex) {
            System.err.println(ex.getResponse().getEntity(String.class));
            throw ex;
        }
        UmaTestUtil.assert_((RptStatusResponse)tokenStatusResponse);
    }

    @Test(dependsOnMethods={"testHostDetermineRptStatus2"})
    public void testReturnProtectedResource() throws Exception {
        this.showTitle("testReturnProtectedResource");
    }
}

