/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.provider.JCERSAPrivateCrtKey;
import org.bouncycastle.jce.provider.JCERSAPublicKey;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.JwkClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.crypto.signature.ECDSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.ECDSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.jws.ECDSASigner;
import org.xdi.oxauth.model.jws.HMACSigner;
import org.xdi.oxauth.model.jws.RSASigner;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.JwtUtil;
import org.xdi.oxauth.model.util.StringUtils;

public class TokenSignaturesHttpTest
extends BaseTest {
    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri"})
    @Test
    public void requestAuthorizationIdTokenHS256(String redirectUris, String userId, String userSecret, String redirectUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenHS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.HS256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        HMACSigner hmacSigner = new HMACSigner(SignatureAlgorithm.HS256, clientSecret);
        Assert.assertTrue((boolean)hmacSigner.validate(jwt));
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri"})
    @Test
    public void requestAuthorizationIdTokenHS384(String redirectUris, String userId, String userSecret, String redirectUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenHS384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.HS384);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        HMACSigner hmacSigner = new HMACSigner(SignatureAlgorithm.HS384, clientSecret);
        Assert.assertTrue((boolean)hmacSigner.validate(jwt));
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri"})
    @Test
    public void requestAuthorizationIdTokenHS512(String redirectUris, String userId, String userSecret, String redirectUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenHS512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.HS512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        String clientSecret = registerResponse.getClientSecret();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(request);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        HMACSigner hmacSigner = new HMACSigner(SignatureAlgorithm.HS512, clientSecret);
        Assert.assertTrue((boolean)hmacSigner.validate(jwt));
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri"})
    @Test
    public void requestAuthorizationIdTokenRS256(String redirectUris, String userId, String userSecret, String redirectUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenRS256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.RS256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS256, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri"})
    @Test
    public void requestAuthorizationIdTokenRS384(String redirectUris, String userId, String userSecret, String redirectUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenRS384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.RS384);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS384, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri"})
    @Test
    public void requestAuthorizationIdTokenRS512(String redirectUris, String userId, String userSecret, String redirectUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenRS512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.RS512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        RSAPublicKey publicKey = JwkClient.getRSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        RSASigner rsaSigner = new RSASigner(SignatureAlgorithm.RS512, publicKey);
        Assert.assertTrue((boolean)rsaSigner.validate(jwt));
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri"})
    @Test
    public void requestAuthorizationIdTokenES256(String redirectUris, String userId, String userSecret, String redirectUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenES256");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.ES256);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        ECDSAPublicKey publicKey = JwkClient.getECDSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        ECDSASigner ecdsaSigner = new ECDSASigner(SignatureAlgorithm.ES256, publicKey);
        Assert.assertTrue((boolean)ecdsaSigner.validate(jwt));
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri"})
    @Test
    public void requestAuthorizationIdTokenES384(String redirectUris, String userId, String userSecret, String redirectUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenES384");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.ES384);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        ECDSAPublicKey publicKey = JwkClient.getECDSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        ECDSASigner ecdsaSigner = new ECDSASigner(SignatureAlgorithm.ES384, publicKey);
        Assert.assertTrue((boolean)ecdsaSigner.validate(jwt));
    }

    @Parameters(value={"redirectUris", "userId", "userSecret", "redirectUri"})
    @Test
    public void requestAuthorizationIdTokenES512(String redirectUris, String userId, String userSecret, String redirectUri) throws Exception {
        this.showTitle("requestAuthorizationIdTokenES512");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setIdTokenSignedResponseAlg(SignatureAlgorithm.ES512);
        registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        authorizationRequest.getPrompts().add(Prompt.NONE);
        authorizationRequest.setAuthUsername(userId);
        authorizationRequest.setAuthPassword(userSecret);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(authorizationRequest);
        AuthorizationResponse authorizationResponse = authorizeClient.exec();
        TokenSignaturesHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)authorizationResponse.getStatus(), (int)302, (String)("Unexpected response code: " + authorizationResponse.getStatus()));
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getIdToken(), (String)"The idToken is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        String idToken = authorizationResponse.getIdToken();
        Jwt jwt = Jwt.parse((String)idToken);
        ECDSAPublicKey publicKey = JwkClient.getECDSAPublicKey((String)this.jwksUri, (String)jwt.getHeader().getClaimAsString("kid"));
        ECDSASigner ecdsaSigner = new ECDSASigner(SignatureAlgorithm.ES512, publicKey);
        Assert.assertTrue((boolean)ecdsaSigner.validate(jwt));
    }

    @Test
    public void printAlgorithmsAndProviders() {
        this.showTitle("printAlgorithmsAndProviders");
        JwtUtil.printAlgorithmsAndProviders();
    }

    @Test
    public void hs256() throws InvalidKeyException, NoSuchAlgorithmException {
        this.showTitle("hs256");
        String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
        String key = "071d68a5-9eb0-47fb-8608-f54a0d9c8ede";
        byte[] signature = JwtUtil.getSignatureHS256((byte[])signingInput.getBytes(), (byte[])key.getBytes());
        String encodedSignature = JwtUtil.base64urlencode((byte[])signature);
        System.out.println("Encoded Signature: " + encodedSignature);
        Assert.assertEquals((String)encodedSignature, (String)"BQwm1HCz0cjHYbulWMumkhZgyb2dD93uScXmC6Fv8Ik");
    }

    @Test
    public void hs384() throws InvalidKeyException, NoSuchAlgorithmException {
        this.showTitle("hs384");
        String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
        String key = "071d68a5-9eb0-47fb-8608-f54a0d9c8ede";
        byte[] signature = JwtUtil.getSignatureHS384((byte[])signingInput.getBytes(), (byte[])key.getBytes());
        String encodedSignature = JwtUtil.base64urlencode((byte[])signature);
        System.out.println("Encoded Signature: " + encodedSignature);
        Assert.assertEquals((String)encodedSignature, (String)"pe7gU1XxroqizSzucuHOor36L-M9_XPZ7KZcR6JW6xQAa2fmTLSDCc02fNER9atB");
    }

    @Test
    public void hs512() throws InvalidKeyException, NoSuchAlgorithmException {
        this.showTitle("hs512");
        String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
        String key = "071d68a5-9eb0-47fb-8608-f54a0d9c8ede";
        byte[] signature = JwtUtil.getSignatureHS512((byte[])signingInput.getBytes(), (byte[])key.getBytes());
        String encodedSignature = JwtUtil.base64urlencode((byte[])signature);
        System.out.println("Encoded Signature: " + encodedSignature);
        Assert.assertEquals((String)encodedSignature, (String)"IZsXiRrRfP9eNFj6snm_MGEnrtfvX8vOF43Z-FuFkRj29y0WUaPR50IXRDI5uGatJvVdr_i7eJCJ4N_EwwrIhQ");
    }

    @Test
    public void rs256() throws NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, IOException, NoSuchPaddingException, BadPaddingException {
        this.showTitle("rs256");
        KeyPair keyPair = JwtUtil.generateRsaKey();
        JCERSAPrivateCrtKey jcersaPrivateCrtKey = (JCERSAPrivateCrtKey)keyPair.getPrivate();
        JCERSAPublicKey jcersaPublicKey = (JCERSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = new RSAPrivateKey(jcersaPrivateCrtKey.getModulus(), jcersaPrivateCrtKey.getPrivateExponent());
        System.out.println("PRIVATE KEY");
        System.out.println("Modulus: " + privateKey.getModulus());
        System.out.println("Private Exponent: " + privateKey.getPrivateExponent());
        RSAPublicKey publicKey = new RSAPublicKey(jcersaPublicKey.getModulus(), jcersaPublicKey.getPublicExponent());
        System.out.println("PUBLIC KEY");
        System.out.println("Modulus: " + publicKey.getModulus());
        System.out.println("Public Exponent: " + publicKey.getPublicExponent());
        String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
        byte[] signature = JwtUtil.getSignatureRS256((byte[])signingInput.getBytes(), (RSAPrivateKey)privateKey);
        String encodedSignature = JwtUtil.base64urlencode((byte[])signature);
        System.out.println("Encoded Signature: " + encodedSignature);
        boolean signatureVerified = JwtUtil.verifySignatureRS256((byte[])signingInput.getBytes(), (byte[])signature, (RSAPublicKey)publicKey);
        Assert.assertTrue((boolean)signatureVerified, (String)"Invalid signature");
    }

    @Test
    public void rs384() throws NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, IOException, NoSuchPaddingException, BadPaddingException {
        this.showTitle("rs384");
        KeyPair keyPair = JwtUtil.generateRsaKey();
        JCERSAPrivateCrtKey jcersaPrivateCrtKey = (JCERSAPrivateCrtKey)keyPair.getPrivate();
        JCERSAPublicKey jcersaPublicKey = (JCERSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = new RSAPrivateKey(jcersaPrivateCrtKey.getModulus(), jcersaPrivateCrtKey.getPrivateExponent());
        System.out.println("PRIVATE KEY");
        System.out.println("Modulus: " + privateKey.getModulus());
        System.out.println("Private Exponent: " + privateKey.getPrivateExponent());
        RSAPublicKey publicKey = new RSAPublicKey(jcersaPublicKey.getModulus(), jcersaPublicKey.getPublicExponent());
        System.out.println("PUBLIC KEY");
        System.out.println("Modulus: " + publicKey.getModulus());
        System.out.println("Public Exponent: " + publicKey.getPublicExponent());
        String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
        byte[] signature = JwtUtil.getSignatureRS384((byte[])signingInput.getBytes(), (RSAPrivateKey)privateKey);
        String encodedSignature = JwtUtil.base64urlencode((byte[])signature);
        System.out.println("Encoded Signature: " + encodedSignature);
        boolean signatureVerified = JwtUtil.verifySignatureRS384((byte[])signingInput.getBytes(), (byte[])signature, (RSAPublicKey)publicKey);
        Assert.assertTrue((boolean)signatureVerified, (String)"Invalid signature");
    }

    @Test
    public void rs512() throws NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, IOException, NoSuchPaddingException, BadPaddingException {
        this.showTitle("rs512");
        KeyPair keyPair = JwtUtil.generateRsaKey();
        JCERSAPrivateCrtKey jcersaPrivateCrtKey = (JCERSAPrivateCrtKey)keyPair.getPrivate();
        JCERSAPublicKey jcersaPublicKey = (JCERSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = new RSAPrivateKey(jcersaPrivateCrtKey.getModulus(), jcersaPrivateCrtKey.getPrivateExponent());
        System.out.println("PRIVATE KEY");
        System.out.println("Modulus: " + privateKey.getModulus());
        System.out.println("Private Exponent: " + privateKey.getPrivateExponent());
        RSAPublicKey publicKey = new RSAPublicKey(jcersaPublicKey.getModulus(), jcersaPublicKey.getPublicExponent());
        System.out.println("PUBLIC KEY");
        System.out.println("Modulus: " + publicKey.getModulus());
        System.out.println("Public Exponent: " + publicKey.getPublicExponent());
        String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
        byte[] signature = JwtUtil.getSignatureRS512((byte[])signingInput.getBytes(), (RSAPrivateKey)privateKey);
        String encodedSignature = JwtUtil.base64urlencode((byte[])signature);
        System.out.println("Encoded Signature: " + encodedSignature);
        boolean signatureVerified = JwtUtil.verifySignatureRS512((byte[])signingInput.getBytes(), (byte[])signature, (RSAPublicKey)publicKey);
        Assert.assertTrue((boolean)signatureVerified, (String)"Invalid signature");
    }

    @Test
    public void es256() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, SignatureException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, IOException, NoSuchPaddingException, BadPaddingException {
        this.showTitle("es256");
        KeyPair keyPair = JwtUtil.generateKeyES256();
        JCEECPrivateKey privateKey = (JCEECPrivateKey)keyPair.getPrivate();
        JCEECPublicKey publicKey = (JCEECPublicKey)keyPair.getPublic();
        ECDSAPrivateKey ecdsaPrivateKey = new ECDSAPrivateKey(privateKey.getD());
        ECDSAPublicKey ecdsaPublicKey = new ECDSAPublicKey(SignatureAlgorithm.ES256, publicKey.getQ().getX().toBigInteger(), publicKey.getQ().getY().toBigInteger());
        System.out.println("PRIVATE KEY");
        System.out.println("D: " + ecdsaPrivateKey.getD());
        System.out.println("PUBLIC KEY");
        System.out.println("X: " + ecdsaPublicKey.getX());
        System.out.println("Y: " + ecdsaPublicKey.getY());
        String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
        byte[] signature = JwtUtil.getSignatureES256((byte[])signingInput.getBytes(), (ECDSAPrivateKey)ecdsaPrivateKey);
        String encodedSignature = JwtUtil.base64urlencode((byte[])signature);
        System.out.println("Encoded Signature: " + encodedSignature);
        boolean signatureVerified = JwtUtil.verifySignatureES256((byte[])signingInput.getBytes(), (byte[])signature, (ECDSAPublicKey)ecdsaPublicKey);
        Assert.assertTrue((boolean)signatureVerified, (String)"Invalid signature");
    }

    @Test
    public void es384() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, SignatureException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, IOException, NoSuchPaddingException, BadPaddingException {
        this.showTitle("es384");
        KeyPair keyPair = JwtUtil.generateKeyES384();
        JCEECPrivateKey privateKey = (JCEECPrivateKey)keyPair.getPrivate();
        JCEECPublicKey publicKey = (JCEECPublicKey)keyPair.getPublic();
        ECDSAPrivateKey ecdsaPrivateKey = new ECDSAPrivateKey(privateKey.getD());
        ECDSAPublicKey ecdsaPublicKey = new ECDSAPublicKey(SignatureAlgorithm.ES384, publicKey.getQ().getX().toBigInteger(), publicKey.getQ().getY().toBigInteger());
        System.out.println("PRIVATE KEY");
        System.out.println("D: " + ecdsaPrivateKey.getD());
        System.out.println("PUBLIC KEY");
        System.out.println("X: " + ecdsaPublicKey.getX());
        System.out.println("Y: " + ecdsaPublicKey.getY());
        String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
        byte[] signature = JwtUtil.getSignatureES384((byte[])signingInput.getBytes(), (ECDSAPrivateKey)ecdsaPrivateKey);
        String encodedSignature = JwtUtil.base64urlencode((byte[])signature);
        System.out.println("Encoded Signature: " + encodedSignature);
        boolean signatureVerified = JwtUtil.verifySignatureES384((byte[])signingInput.getBytes(), (byte[])signature, (ECDSAPublicKey)ecdsaPublicKey);
        Assert.assertTrue((boolean)signatureVerified, (String)"Invalid signature");
    }

    @Test
    public void es512() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, SignatureException, InvalidKeyException, InvalidKeySpecException, IllegalBlockSizeException, IOException, NoSuchPaddingException, BadPaddingException {
        this.showTitle("es512");
        KeyPair keyPair = JwtUtil.generateKeyES512();
        JCEECPrivateKey privateKey = (JCEECPrivateKey)keyPair.getPrivate();
        JCEECPublicKey publicKey = (JCEECPublicKey)keyPair.getPublic();
        ECDSAPrivateKey ecdsaPrivateKey = new ECDSAPrivateKey(privateKey.getD());
        ECDSAPublicKey ecdsaPublicKey = new ECDSAPublicKey(SignatureAlgorithm.ES512, publicKey.getQ().getX().toBigInteger(), publicKey.getQ().getY().toBigInteger());
        System.out.println("PRIVATE KEY");
        System.out.println("D: " + ecdsaPrivateKey.getD());
        System.out.println("PUBLIC KEY");
        System.out.println("X: " + ecdsaPublicKey.getX());
        System.out.println("Y: " + ecdsaPublicKey.getY());
        String signingInput = "eyJhbGciOiJIUzI1NiJ9.eyJub25jZSI6ICI2Qm9HN1QwR0RUZ2wiLCAiaWRfdG9rZW4iOiB7Im1heF9hZ2UiOiA4NjQwMH0sICJzdGF0ZSI6ICJTVEFURTAiLCAicmVkaXJlY3RfdXJpIjogImh0dHBzOi8vbG9jYWxob3N0L2NhbGxiYWNrMSIsICJ1c2VyaW5mbyI6IHsiY2xhaW1zIjogeyJuYW1lIjogbnVsbH19LCAiY2xpZW50X2lkIjogIkAhMTExMSEwMDA4IUU2NTQuQjQ2MCIsICJzY29wZSI6IFsib3BlbmlkIl0sICJyZXNwb25zZV90eXBlIjogWyJjb2RlIl19";
        byte[] signature = JwtUtil.getSignatureES512((byte[])signingInput.getBytes(), (ECDSAPrivateKey)ecdsaPrivateKey);
        String encodedSignature = JwtUtil.base64urlencode((byte[])signature);
        System.out.println("Encoded Signature: " + encodedSignature);
        boolean signatureVerified = JwtUtil.verifySignatureES512((byte[])signingInput.getBytes(), (byte[])signature, (ECDSAPublicKey)ecdsaPublicKey);
        Assert.assertTrue((boolean)signatureVerified, (String)"Invalid signature");
    }

    @Test
    public void getMessageDigestSHA256() {
        this.showTitle("sha256");
        try {
            String input = "The quick brown fox jumps over the lazy dog";
            System.out.println("Input: " + input);
            byte[] digest = JwtUtil.getMessageDigestSHA256((String)input);
            BigInteger result = new BigInteger(1, digest);
            BigInteger expectedResult = new BigInteger("d7a8fbb307d7809469ca9abcb0082e4f8d5651e46d3cdb762d02d0bf37c9e592", 16);
            System.out.println("Result  : " + result);
            System.out.println("Expected: " + expectedResult);
            Assert.assertEquals((Object)result, (Object)expectedResult);
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void getMessageDigestSHA384() {
        this.showTitle("sha384");
        try {
            String input = "The quick brown fox jumps over the lazy dog";
            System.out.println("Input: " + input);
            byte[] digest = JwtUtil.getMessageDigestSHA384((String)input);
            BigInteger result = new BigInteger(1, digest);
            BigInteger expectedResult = new BigInteger("ca737f1014a48f4c0b6dd43cb177b0afd9e5169367544c494011e3317dbf9a509cb1e5dc1e85a941bbee3d7f2afbc9b1", 16);
            System.out.println("Result   : " + result);
            System.out.println("Expected : " + expectedResult);
            Assert.assertEquals((Object)result, (Object)expectedResult);
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void getMessageDigestSHA512() {
        this.showTitle("sha512");
        try {
            String input = "The quick brown fox jumps over the lazy dog";
            System.out.println("Input: " + input);
            byte[] digest = JwtUtil.getMessageDigestSHA512((String)input);
            BigInteger result = new BigInteger(1, digest);
            BigInteger expectedResult = new BigInteger("07e547d9586f6a73f73fbac0435ed76951218fb7d0c8d788a309d785436bbb642e93a252a954f23912547d1e8a3b5ed6e1bfd7097821233fa0538f3db854fee6", 16);
            System.out.println("Result   : " + result);
            System.out.println("Expected : " + expectedResult);
            Assert.assertEquals((Object)result, (Object)expectedResult);
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

