/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryClient;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryRequest;
import org.xdi.oxauth.client.OpenIdConnectDiscoveryResponse;

public class OpenIDConnectDiscoveryHttpTest
extends BaseTest {
    @Test
    public void emailNormalization1() throws Exception {
        String resource = "acct:joe@example.com";
        String expectedHost = "example.com";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void emailNormalization2() throws Exception {
        String resource = "joe@example.com";
        String expectedHost = "example.com";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void emailNormalization3() throws Exception {
        String resource = "acct:joe@example.com:8080";
        String expectedHost = "example.com:8080";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void emailNormalization4() throws Exception {
        String resource = "joe@example.com:8080";
        String expectedHost = "example.com:8080";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void emailNormalization5() throws Exception {
        String resource = "joe@localhost";
        String expectedHost = "localhost";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void emailNormalization6() throws Exception {
        String resource = "joe@localhost:8080";
        String expectedHost = "localhost:8080";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void urlNormalization1() throws Exception {
        String resource = "https://example.com";
        String expectedHost = "example.com";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void urlNormalization2() throws Exception {
        String resource = "https://example.com/joe";
        String expectedHost = "example.com";
        String expectedPath = "/joe";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }

    @Test
    public void urlNormalization3() throws Exception {
        String resource = "https://example.com:8080/";
        String expectedHost = "example.com:8080";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void urlNormalization4() throws Exception {
        String resource = "https://example.com:8080/joe";
        String expectedHost = "example.com:8080";
        String expectedPath = "/joe";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }

    @Test
    public void urlNormalization5() throws Exception {
        String resource = "https://example.com:8080/joe#fragment";
        String expectedHost = "example.com:8080";
        String expectedPath = "/joe";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }

    @Test
    public void urlNormalization6() throws Exception {
        String resource = "https://example.com:8080/joe?param=value";
        String expectedHost = "example.com:8080";
        String expectedPath = "/joe";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }

    @Test
    public void urlNormalization7() throws Exception {
        String resource = "https://example.com:8080/joe?param1=foo&param2=bar#fragment";
        String expectedHost = "example.com:8080";
        String expectedPath = "/joe";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }

    @Test
    public void hostNormalization1() throws Exception {
        String resource = "example.com";
        String expectedHost = "example.com";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void hostNormalization2() throws Exception {
        String resource = "example.com:8080";
        String expectedHost = "example.com:8080";
        String expectedPath = null;
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), expectedPath);
    }

    @Test
    public void hostNormalization3() throws Exception {
        String resource = "example.com/path";
        String expectedHost = "example.com";
        String expectedPath = "/path";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }

    @Test
    public void hostNormalization4() throws Exception {
        String resource = "example.com:8080/path";
        String expectedHost = "example.com:8080";
        String expectedPath = "/path";
        OpenIdConnectDiscoveryRequest openIdConnectDiscoveryRequest = new OpenIdConnectDiscoveryRequest(resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getResource(), (String)resource);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getHost(), (String)expectedHost);
        Assert.assertEquals((String)openIdConnectDiscoveryRequest.getPath(), (String)expectedPath);
    }

    @Parameters(value={"swdResource"})
    @Test
    public void requestOpenIdConnectDiscovery(String resource) throws Exception {
        this.showTitle("requestOpenIdConnectDiscovery");
        OpenIdConnectDiscoveryClient client = new OpenIdConnectDiscoveryClient(resource);
        OpenIdConnectDiscoveryResponse response = client.exec();
        OpenIDConnectDiscoveryHttpTest.showClient((BaseClient)client);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code");
        Assert.assertNotNull((Object)response.getSubject());
        Assert.assertTrue((response.getLinks().size() > 0 ? 1 : 0) != 0);
    }
}

