/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.ArrayList;
import java.util.UUID;
import org.apache.http.client.HttpClient;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.ClientInfoClient;
import org.xdi.oxauth.client.ClientInfoRequest;
import org.xdi.oxauth.client.ClientInfoResponse;
import org.xdi.oxauth.dev.HostnameVerifierType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;

public class FederationScopesWSHttpTest
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "clientId", "redirectUri"})
    @Test
    public void requestClientInfo(String userId, String userSecret, String clientId, String redirectUri) throws Exception {
        this.showTitle("FederationScopesWSHttpTest.requestClientInfo");
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        responseTypes.add(ResponseType.ID_TOKEN);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("clientinfo");
        scopes.add("email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        request.setState(state);
        request.setAuthUsername(userId);
        request.setAuthPassword(userSecret);
        request.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(this.authorizationEndpoint);
        authorizeClient.setRequest(request);
        AuthorizationResponse response1 = authorizeClient.exec((ClientExecutor)new ApacheHttpClient4Executor((HttpClient)FederationScopesWSHttpTest.createHttpClient(HostnameVerifierType.ALLOW_ALL)));
        FederationScopesWSHttpTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope must be null");
        Assert.assertNotNull((Object)response1.getIdToken(), (String)"The id token must be null");
        String accessToken = response1.getAccessToken();
        ClientInfoClient clientInfoClient = new ClientInfoClient(this.clientInfoEndpoint);
        clientInfoClient.setRequest(new ClientInfoRequest(accessToken));
        ClientInfoResponse response2 = clientInfoClient.exec((ClientExecutor)new ApacheHttpClient4Executor((HttpClient)FederationScopesWSHttpTest.createHttpClient(HostnameVerifierType.ALLOW_ALL)));
        FederationScopesWSHttpTest.showClient((BaseClient)clientInfoClient);
        Assert.assertEquals((int)response2.getStatus(), (int)200, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getClaim("displayName"), (String)"Unexpected result: displayName not found");
        Assert.assertNotNull((Object)response2.getClaim("inum"), (String)"Unexpected result: inum not found");
        Assert.assertNotNull((Object)response2.getClaim("oxAuthAppType"), (String)"Unexpected result: oxAuthAppType not found");
        Assert.assertNotNull((Object)response2.getClaim("oxAuthIdTokenSignedResponseAlg"), (String)"Unexpected result: oxAuthIdTokenSignedResponseAlg not found");
        Assert.assertNotNull((Object)response2.getClaim("oxAuthRedirectURI"), (String)"Unexpected result: oxAuthRedirectURI not found");
        Assert.assertNotNull((Object)response2.getClaim("oxAuthScope"), (String)"Unexpected result: oxAuthScope not found");
    }
}

