/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.FederationMetadataClient;
import org.xdi.oxauth.client.FederationMetadataRequest;
import org.xdi.oxauth.client.FederationMetadataResponse;
import org.xdi.oxauth.model.federation.FederationOP;
import org.xdi.oxauth.model.federation.FederationRP;

public class FederationMetadataWebServiceHttpTest
extends BaseTest {
    @Test
    public void requestExistingFederationMetadataIdList() throws Exception {
        this.showTitle("requestExistingFederationMetadataIdList");
        FederationMetadataClient client = new FederationMetadataClient(this.federationMetadataEndpoint);
        FederationMetadataResponse response = client.execGetMetadataIds();
        FederationMetadataWebServiceHttpTest.showClient((BaseClient)client);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. Entity: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertTrue((response.getExistingMetadataIdList() != null && !response.getExistingMetadataIdList().isEmpty() ? 1 : 0) != 0, (String)"MetadataId list is empty. It's expected to have not empty list");
    }

    @Parameters(value={"federationMetadataId"})
    @Test
    public void requestFederationMetadataById(String federationMetadataId) throws Exception {
        this.showTitle("requestFederationMetadataId");
        FederationMetadataClient client = new FederationMetadataClient(this.federationMetadataEndpoint);
        FederationMetadataResponse response = client.execGetMetadataById(federationMetadataId);
        FederationMetadataWebServiceHttpTest.showClient((BaseClient)client);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. Entity: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getMetadata(), (String)"The metadata is null");
        Assert.assertNotNull((Object)response.getMetadata().getId(), (String)"The metadata id is null");
        Assert.assertNotNull((Object)response.getMetadata().getDisplayName(), (String)"The metadata displayName is null");
        Assert.assertNotNull((Object)response.getMetadata().getIntervalCheck(), (String)"The metadata intervalCheck is not set");
        List rpList = response.getMetadata().getRpList();
        List opList = response.getMetadata().getOpList();
        Assert.assertTrue((rpList != null && !rpList.isEmpty() ? 1 : 0) != 0, (String)"The metadata rp list is not set");
        Assert.assertTrue((opList != null && !opList.isEmpty() ? 1 : 0) != 0, (String)"The metadata op list is not set");
        Assert.assertNotNull((Object)((FederationRP)rpList.get(0)).getDisplayName(), (String)"The metadata rp's display_name attribute is not set");
        Assert.assertNotNull((Object)((FederationRP)rpList.get(0)).getRedirectUri(), (String)"The metadata rp's redirect_uri attribute is not set");
        Assert.assertNotNull((Object)((FederationOP)opList.get(0)).getDisplayName(), (String)"The metadata op's display_name attribute is not set");
        Assert.assertNotNull((Object)((FederationOP)opList.get(0)).getOpId(), (String)"The metadata op's op_id attribute is not set");
        Assert.assertNotNull((Object)((FederationOP)opList.get(0)).getDomain(), (String)"The metadata op's domain attribute is not set");
    }

    @Parameters(value={"federationMetadataId"})
    @Test
    public void requestFederationMetadataByIdNotSigned(String federationMetadataId) throws Exception {
        this.showTitle("requestFederationMetadataId");
        FederationMetadataClient client = new FederationMetadataClient(this.federationMetadataEndpoint);
        FederationMetadataRequest request = new FederationMetadataRequest();
        request.setFederationId(federationMetadataId);
        request.setSigned(false);
        FederationMetadataResponse response = client.exec(request);
        FederationMetadataWebServiceHttpTest.showClient((BaseClient)client);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. Entity: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getMetadata(), (String)"The metadata is null");
        Assert.assertNotNull((Object)response.getMetadata().getId(), (String)"The metadata id is null");
        Assert.assertNotNull((Object)response.getMetadata().getDisplayName(), (String)"The metadata displayName is null");
        Assert.assertNotNull((Object)response.getMetadata().getIntervalCheck(), (String)"The metadata intervalCheck is not set");
        List rpList = response.getMetadata().getRpList();
        List opList = response.getMetadata().getOpList();
        Assert.assertTrue((rpList != null && !rpList.isEmpty() ? 1 : 0) != 0, (String)"The metadata rp list is not set");
        Assert.assertTrue((opList != null && !opList.isEmpty() ? 1 : 0) != 0, (String)"The metadata op list is not set");
        Assert.assertNotNull((Object)((FederationRP)rpList.get(0)).getDisplayName(), (String)"The metadata rp's display_name attribute is not set");
        Assert.assertNotNull((Object)((FederationRP)rpList.get(0)).getRedirectUri(), (String)"The metadata rp's redirect_uri attribute is not set");
        Assert.assertNotNull((Object)((FederationOP)opList.get(0)).getDisplayName(), (String)"The metadata op's display_name attribute is not set");
        Assert.assertNotNull((Object)((FederationOP)opList.get(0)).getOpId(), (String)"The metadata op's op_id attribute is not set");
        Assert.assertNotNull((Object)((FederationOP)opList.get(0)).getDomain(), (String)"The metadata op's domain attribute is not set");
    }

    @Test
    public void requestFederationMetadataByIdFail() throws Exception {
        this.showTitle("requestFederationMetadataIdFail");
        FederationMetadataClient client = new FederationMetadataClient(this.federationMetadataEndpoint);
        FederationMetadataResponse response = client.execGetMetadataById("notExistingId");
        FederationMetadataWebServiceHttpTest.showClient((BaseClient)client);
        Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code. Entity: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
        Assert.assertNotNull((Object)response.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)response.getErrorDescription(), (String)"The error description is null");
    }
}

