/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.jce.provider.JCERSAPrivateCrtKey;
import org.bouncycastle.jce.provider.JCERSAPublicKey;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.xdi.oxauth.model.crypto.signature.RSAPrivateKey;
import org.xdi.oxauth.model.crypto.signature.RSAPublicKey;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwt.JwtHeader;
import org.xdi.oxauth.model.jwt.JwtType;
import org.xdi.oxauth.model.util.JwtUtil;

public class FederationMetadataSignatureTest {
    private static final String TEST_METADATA = "{\"federation_id\"  : \"@!2222!0008!FF8F!7434\",\n \"display_name\" : \"Federation example name\",\n \"OPs\" : [\n          {\n            \"display_name\" : \"Example OP\",\n            \"op_id\" : \"example.com\",\n            \"domain\" : \"example.com\"\n          }          \n         ],\n \"RPs\" : [\n          {\n            \"display_name\" : \"oxGraph client\",\n            \"redirect_uri\" : \"example.com/oxGraph\"\n          }\n         ]        \n}";

    @Test
    public void test() throws JSONException, NoSuchProviderException, NoSuchAlgorithmException, IOException, IllegalBlockSizeException, InvalidKeyException, InvalidKeySpecException, NoSuchPaddingException, BadPaddingException, InvalidJwtException {
        JSONObject jsonHeader = JwtHeader.instance().setType(JwtType.JWS).setAlgorithm(SignatureAlgorithm.RS512).toJsonObject();
        JSONObject jsonPayload = new JSONObject(TEST_METADATA);
        KeyPair keyPair = JwtUtil.generateRsaKey();
        JCERSAPrivateCrtKey jcersaPrivateCrtKey = (JCERSAPrivateCrtKey)keyPair.getPrivate();
        JCERSAPublicKey jcersaPublicKey = (JCERSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = new RSAPrivateKey(jcersaPrivateCrtKey.getModulus(), jcersaPrivateCrtKey.getPrivateExponent());
        RSAPublicKey publicKey = new RSAPublicKey(jcersaPublicKey.getModulus(), jcersaPublicKey.getPublicExponent());
        String encodedString = JwtUtil.encodeJwt((JSONObject)jsonHeader, (JSONObject)jsonPayload, (SignatureAlgorithm)SignatureAlgorithm.RS512, (RSAPrivateKey)privateKey);
        System.out.println("Encoded string: " + encodedString);
        String[] parts = encodedString.split("\\.");
        if (parts.length == 3) {
            String encodedHeader = parts[0];
            String encodedPayload = parts[1];
            String encodedSignature = parts[2];
            String header = new String(JwtUtil.base64urldecode((String)encodedHeader), "UTF-8");
            String payload = new String(JwtUtil.base64urldecode((String)encodedPayload), "UTF-8");
            System.out.println("Header: " + header);
            System.out.println("Payload: " + payload);
            byte[] signature = JwtUtil.base64urldecode((String)encodedSignature);
            String signingInput = encodedHeader + "." + encodedPayload;
            boolean signatureVerified = JwtUtil.verifySignatureRS512((byte[])signingInput.getBytes("UTF-8"), (byte[])signature, (RSAPublicKey)publicKey);
            Assert.assertTrue((boolean)signatureVerified, (String)"Invalid signature");
        }
    }
}

