/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.FederationDataClient;
import org.xdi.oxauth.client.FederationDataResponse;

public class FederationDataWebServiceHttpTest
extends BaseTest {
    @Parameters(value={"federationMetadataId", "federationRpDisplayName", "federationRpRedirectUri"})
    @Test
    public void requestRpJoin(String federationMetadataId, String federationRpDisplayName, String federationRpRedirectUri) throws Exception {
        this.showTitle("requestRpJoin");
        FederationDataClient client = new FederationDataClient(this.federationEndpoint);
        FederationDataResponse response = client.joinRP(federationMetadataId, federationRpDisplayName, federationRpRedirectUri);
        FederationDataWebServiceHttpTest.showClient((BaseClient)client);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. Entity: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
    }

    @Parameters(value={"federationMetadataId", "federationRpDisplayName", "federationRpRedirectUris"})
    @Test
    public void requestRpJoinWithMultipleUris(String federationMetadataId, String federationRpDisplayName, String federationRpRedirectUris) throws Exception {
        this.showTitle("requestRpJoinWithMultipleUris");
        FederationDataClient client = new FederationDataClient(this.federationEndpoint);
        FederationDataResponse response = client.joinRP(federationMetadataId, federationRpDisplayName, federationRpRedirectUris);
        FederationDataWebServiceHttpTest.showClient((BaseClient)client);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. Entity: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getEntity(), (String)"The entity is null");
    }
}

