/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.load;

import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class RegistrationLoadTest
extends BaseTest {
    @Parameters(value={"redirectUris"})
    @Test(invocationCount=1000, threadPoolSize=100)
    public void registerClient(String redirectUris) throws Exception {
        this.showTitle("requestClientAssociate1");
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        RegisterResponse response = registerClient.execRegister(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        RegistrationLoadTest.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
        RegisterRequest readClientRequest = new RegisterRequest(response.getRegistrationAccessToken());
        RegisterClient readClient = new RegisterClient(response.getRegistrationClientUri());
        readClient.setRequest(readClientRequest);
        RegisterResponse readClientResponse = readClient.exec();
        RegistrationLoadTest.showClient((BaseClient)readClient);
        Assert.assertEquals((int)readClientResponse.getStatus(), (int)200, (String)("Unexpected response code: " + readClientResponse.getEntity()));
        Assert.assertNotNull((Object)readClientResponse.getClientId());
        Assert.assertNotNull((Object)readClientResponse.getClientSecret());
        Assert.assertNotNull((Object)readClientResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)readClientResponse.getClientSecretExpiresAt());
    }
}

