/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoRequest;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.model.common.AuthorizationMethod;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class UserInfoEndpointAccessWithFormEncodedBodyMethod
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUris", "redirectUri", "sectorIdentifierUri"})
    @Test
    public void userInfoEndpointAccessWithFormEncodedBodyMethod(String userId, String userSecret, String redirectUris, String redirectUri, String sectorIdentifierUri) throws Exception {
        this.showTitle("OC5:FeatureTest-UserInfo Endpoint Access with Form-Encoded Body Method");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.TOKEN, ResponseType.ID_TOKEN);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setResponseTypes(responseTypes);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        UserInfoEndpointAccessWithFormEncodedBodyMethod.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String nonce = UUID.randomUUID().toString();
        String state = "STATE_XYZ";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation());
        Assert.assertNotNull((Object)authorizationResponse.getAccessToken());
        Assert.assertNotNull((Object)authorizationResponse.getIdToken());
        Assert.assertNotNull((Object)authorizationResponse.getState());
        String accessToken = authorizationResponse.getAccessToken();
        UserInfoRequest userInfoRequest = new UserInfoRequest(accessToken);
        userInfoRequest.setAuthorizationMethod(AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER);
        UserInfoClient userInfoClient = new UserInfoClient(this.userInfoEndpoint);
        userInfoClient.setRequest(userInfoRequest);
        UserInfoResponse userInfoResponse = userInfoClient.exec();
        UserInfoEndpointAccessWithFormEncodedBodyMethod.showClient((BaseClient)userInfoClient);
        Assert.assertEquals((int)userInfoResponse.getStatus(), (int)200, (String)("Unexpected response code: " + userInfoResponse.getStatus()));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("sub"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("given_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("family_name"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("email"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("zoneinfo"));
        Assert.assertNotNull((Object)userInfoResponse.getClaim("locale"));
    }
}

