/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class RejectRegistrationOfRedirectUriWithFragment
extends BaseTest {
    @Parameters(value={"redirectUri"})
    @Test
    public void rejectRegistrationOfRedirectUriWithFragment(String redirectUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Reject Registration of redirect uri with Fragment");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)(redirectUri + "#foo1=bar")));
        registerRequest.setResponseTypes(responseTypes);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        RejectRegistrationOfRedirectUriWithFragment.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)400, (String)("Unexpected response code: " + registerResponse.getStatus()));
        Assert.assertNotNull((Object)registerResponse.getErrorType(), (String)"The error type is null");
        Assert.assertNotNull((Object)registerResponse.getErrorDescription(), (String)"The error description is null");
    }
}

