/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class EnablesDynamicRegistration
extends BaseTest {
    @Parameters(value={"redirectUris", "sectorIdentifierUri", "clientJwksUri"})
    @Test
    public void enablesDynamicRegistration(String redirectUris, String sectorIdentifierUri, String clientJwksUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Enables Dynamic Registration");
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
        registerRequest.setContacts(Arrays.asList("javier@gluu.org", "javier.rojas.blum@gmail.com"));
        registerRequest.setLogoUri("http://www.gluu.org/wp-content/themes/gluursn/images/logo.png");
        registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
        registerRequest.setPolicyUri("http://www.gluu.org/policy");
        registerRequest.setJwksUri(clientJwksUri);
        registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
        registerRequest.setSubjectType(SubjectType.PUBLIC);
        registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS256);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse response = registerClient.exec();
        EnablesDynamicRegistration.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code: " + response.getEntity()));
        Assert.assertNotNull((Object)response.getClientId());
        Assert.assertNotNull((Object)response.getClientSecret());
        Assert.assertNotNull((Object)response.getRegistrationAccessToken());
        Assert.assertNotNull((Object)response.getRegistrationClientUri());
        Assert.assertNotNull((Object)response.getClientIdIssuedAt());
        Assert.assertNotNull((Object)response.getClientSecretExpiresAt());
    }
}

