/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.interop;

import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.RegisterClient;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.StringUtils;

public class AcceptRequestWithoutRedirectUriWhenOneRegistered
extends BaseTest {
    @Parameters(value={"userId", "userSecret", "redirectUri"})
    @Test
    public void acceptRequestWithoutRedirectUriWhenOneRegistered(String userId, String userSecret, String redirectUri) throws Exception {
        this.showTitle("OC5:FeatureTest-Accept Request Without redirect uri when One Registered");
        List<ResponseType> responseTypes = Arrays.asList(ResponseType.CODE);
        RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUri));
        registerRequest.setResponseTypes(responseTypes);
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse registerResponse = registerClient.exec();
        AcceptRequestWithoutRedirectUriWhenOneRegistered.showClient((BaseClient)registerClient);
        Assert.assertEquals((int)registerResponse.getStatus(), (int)200, (String)("Unexpected response code: " + registerResponse.getEntity()));
        Assert.assertNotNull((Object)registerResponse.getClientId());
        Assert.assertNotNull((Object)registerResponse.getClientSecret());
        Assert.assertNotNull((Object)registerResponse.getRegistrationAccessToken());
        Assert.assertNotNull((Object)registerResponse.getClientIdIssuedAt());
        Assert.assertNotNull((Object)registerResponse.getClientSecretExpiresAt());
        String clientId = registerResponse.getClientId();
        List<String> scopes = Arrays.asList("openid", "profile", "address", "email");
        String state = "af0ifjsldkj";
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, null, null);
        authorizationRequest.setState(state);
        AuthorizationResponse authorizationResponse = this.authenticateResourceOwnerAndGrantAccess(this.authorizationEndpoint, authorizationRequest, userId, userSecret);
        Assert.assertNotNull((Object)authorizationResponse.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)authorizationResponse.getCode(), (String)"The authorization code is null");
        Assert.assertNotNull((Object)authorizationResponse.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)authorizationResponse.getScope(), (String)"The scope is null");
    }
}

