/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.dev;

import java.util.Arrays;
import junit.framework.Assert;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.TokenClient;
import org.xdi.oxauth.client.TokenResponse;
import org.xdi.oxauth.client.UserInfoClient;
import org.xdi.oxauth.client.UserInfoResponse;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;

public class TestSessionWorkflow
extends BaseTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Parameters(value={"userId", "userSecret", "clientId", "clientSecret", "redirectUri"})
    @Test
    public void test(String userId, String userSecret, String clientId, String clientSecret, String redirectUri) throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            BasicCookieStore cookieStore = new BasicCookieStore();
            httpClient.setCookieStore((CookieStore)cookieStore);
            ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor((HttpClient)httpClient);
            AuthorizationRequest authorizationRequest1 = new AuthorizationRequest(Arrays.asList(ResponseType.CODE), clientId, Arrays.asList("openid", "profile", "email"), redirectUri, null);
            authorizationRequest1.setAuthUsername(userId);
            authorizationRequest1.setAuthPassword(userSecret);
            authorizationRequest1.getPrompts().add(Prompt.NONE);
            authorizationRequest1.setState("af0ifjsldkj");
            authorizationRequest1.setRequestSessionId(true);
            AuthorizeClient authorizeClient1 = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient1.setRequest(authorizationRequest1);
            AuthorizationResponse authorizationResponse1 = authorizeClient1.exec((ClientExecutor)clientExecutor);
            String code1 = authorizationResponse1.getCode();
            String sessionId = authorizationResponse1.getSessionId();
            Assert.assertNotNull((String)"code1 is null", (Object)code1);
            Assert.assertNotNull((String)"sessionId is null", (Object)sessionId);
            TokenClient tokenClient1 = new TokenClient(this.tokenEndpoint);
            TokenResponse tokenResponse1 = tokenClient1.execAuthorizationCode(code1, redirectUri, clientId, clientSecret);
            String accessToken1 = tokenResponse1.getAccessToken();
            Assert.assertNotNull((String)"accessToken1 is null", (Object)accessToken1);
            UserInfoClient userInfoClient1 = new UserInfoClient(this.userInfoEndpoint);
            UserInfoResponse userInfoResponse1 = userInfoClient1.execUserInfo(accessToken1);
            Assert.assertTrue((String)"userInfoResponse1.getStatus() is not 200", (userInfoResponse1.getStatus() == 200 ? 1 : 0) != 0);
            AuthorizationRequest authorizationRequest2 = new AuthorizationRequest(Arrays.asList(ResponseType.CODE), clientId, Arrays.asList("openid", "profile", "email"), redirectUri, null);
            authorizationRequest2.getPrompts().add(Prompt.NONE);
            authorizationRequest2.setState("af0ifjsldkj");
            authorizationRequest2.setSessionId(sessionId);
            AuthorizeClient authorizeClient2 = new AuthorizeClient(this.authorizationEndpoint);
            authorizeClient2.setRequest(authorizationRequest2);
            AuthorizationResponse authorizationResponse2 = authorizeClient2.exec((ClientExecutor)clientExecutor);
            String code2 = authorizationResponse2.getCode();
            Assert.assertNotNull((String)"code2 is null", (Object)code2);
            TokenClient tokenClient2 = new TokenClient(this.tokenEndpoint);
            TokenResponse tokenResponse2 = tokenClient2.execAuthorizationCode(code2, redirectUri, clientId, clientSecret);
            String accessToken2 = tokenResponse2.getAccessToken();
            Assert.assertNotNull((String)"accessToken2 is null", (Object)accessToken2);
            UserInfoClient userInfoClient2 = new UserInfoClient(this.userInfoEndpoint);
            UserInfoResponse userInfoResponse2 = userInfoClient2.execUserInfo(accessToken2);
            Assert.assertTrue((String)"userInfoResponse1.getStatus() is not 200", (userInfoResponse1.getStatus() == 200 ? 1 : 0) != 0);
        }
        finally {
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
            }
        }
    }

    @Parameters(value={"userId", "userSecret", "clientId", "clientSecret", "redirectUri"})
    public void stressTest(String userId, String userSecret, String clientId, String clientSecret, String redirectUri) throws Exception {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 500; ++i) {
            System.out.println(i);
            this.test(userId, userSecret, clientId, clientSecret, redirectUri);
        }
        long endTime = System.currentTimeMillis();
        System.out.println((endTime - startTime) / 1000L);
    }
}

