/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.dev;

import java.util.ArrayList;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.AuthorizationResponse;
import org.xdi.oxauth.client.AuthorizeClient;
import org.xdi.oxauth.client.BaseClient;
import org.xdi.oxauth.client.EndSessionClient;
import org.xdi.oxauth.client.EndSessionResponse;
import org.xdi.oxauth.model.common.ResponseType;

public class StressTestManual {
    private static final String CLIENT_ID = "@!1111!0008!0074.74C0";
    private static final String REDIRECT_URI = "https://client.example.com/cb";
    private static final String AUTHORIZE_URL = "http://localhost:8085/seam/resource/restv1/oxauth/authorize";
    private static final String END_SESSION_URL = "http://localhost:8085/seam/resource/restv1/oxauth/end_session";
    private static final String POST_LOGOUT_REDIRECT_URI = "https://client.example.com/pl";
    private static final String USER_ID = "mike";
    private static final String SECRET = "secret";

    @Test(threadPoolSize=10, invocationCount=100000, timeOut=10000L)
    public void authCode() {
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("openid");
        scopes.add("profile");
        scopes.add("address");
        scopes.add("email");
        String nonce = UUID.randomUUID().toString();
        String state = "af0ifjsldkj";
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, CLIENT_ID, scopes, REDIRECT_URI, nonce);
        request.setState("af0ifjsldkj");
        request.setAuthUsername(USER_ID);
        request.setAuthPassword(SECRET);
        AuthorizeClient authorizeClient = new AuthorizeClient(AUTHORIZE_URL);
        authorizeClient.setRequest(request);
        AuthorizationResponse response1 = authorizeClient.exec();
        BaseTest.showClient((BaseClient)authorizeClient);
        Assert.assertEquals((int)response1.getStatus(), (int)302, (String)("Unexpected response code: " + response1.getStatus()));
        Assert.assertNotNull((Object)response1.getLocation(), (String)"The location is null");
        Assert.assertNotNull((Object)response1.getAccessToken(), (String)"The access token is null");
        Assert.assertNotNull((Object)response1.getState(), (String)"The state is null");
        Assert.assertNotNull((Object)response1.getTokenType(), (String)"The token type is null");
        Assert.assertNotNull((Object)response1.getExpiresIn(), (String)"The expires in value is null");
        Assert.assertNotNull((Object)response1.getScope(), (String)"The scope must be null");
        String idToken = response1.getIdToken();
        EndSessionClient endSessionClient = new EndSessionClient(END_SESSION_URL);
        EndSessionResponse response2 = endSessionClient.execEndSession(idToken, POST_LOGOUT_REDIRECT_URI);
        BaseTest.showClient((BaseClient)endSessionClient);
        Assert.assertEquals((int)response2.getStatus(), (int)302, (String)("Unexpected response code: " + response2.getStatus()));
        Assert.assertNotNull((Object)response2.getLocation(), (String)"The location is null");
    }
}

